/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.RemoteAPIService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.ResyncService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;

@Named
@SessionScoped
public class InspectController
implements Serializable {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(InspectController.class.getName());
    String uniqueid = null;
    List<String> snapshotIDs = null;
    String currentSnapshotID = null;
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Inject
    ResyncService syncService;
    @Inject
    MessageService messageService;
    @Inject
    RemoteAPIService remoteAPIService;

    public String getUniqueid() {
        return this.uniqueid;
    }

    public void setUniqueid(String uniqueid) {
        this.uniqueid = uniqueid;
    }

    public List<String> getSnapshotIDs() {
        if (this.snapshotIDs == null) {
            this.snapshotIDs = new ArrayList();
        }
        return this.snapshotIDs;
    }

    public void setSnapshotIDs(List<String> snapshotIDs) {
        this.snapshotIDs = snapshotIDs;
    }

    public String getCurrentSnapshotID() {
        return this.currentSnapshotID;
    }

    public void setCurrentSnapshotID(String currentSnapshotID) {
        this.currentSnapshotID = currentSnapshotID;
    }

    public String getTime(String id) {
        String sTime = id.substring(id.lastIndexOf(45) + 1);
        long time = Long.parseLong(sTime);
        Date date = new Date(time);
        return date.toString();
    }

    public void loadSnapshotIDs() {
        try {
            logger.finest("......load snapshots for " + this.uniqueid + "...");
            this.snapshotIDs = this.dataService.loadSnapshotsByUnqiueID(this.uniqueid, 100, true);
            this.setCurrentSnapshotID(this.remoteAPIService.readSnapshotIDByUniqueID(this.uniqueid));
        }
        catch (ArchiveException e) {
            logger.severe("failed to load snapshot ids: " + e.getMessage());
        }
    }

    public void restoreSnapshot(String id) {
        try {
            logger.info("......restore snapshotID " + this.uniqueid + "...");
            ItemCollection snapshot = this.dataService.loadSnapshot(id);
            this.remoteAPIService.restoreSnapshot(snapshot);
            this.loadSnapshotIDs();
        }
        catch (ArchiveException e) {
            logger.severe("failed to load snapshot ids: " + e.getMessage());
        }
    }

    public void deleteSnapshot(String id) {
        try {
            logger.info("......delete snapshotID " + this.uniqueid + "...");
            this.dataService.deleteSnapshot(id);
            this.loadSnapshotIDs();
        }
        catch (ArchiveException e) {
            logger.severe("failed to load snapshot ids: " + e.getMessage());
        }
    }
}

