/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.Timer;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.restore.RestoreService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;

@Named
@SessionScoped
public class RestoreController
implements Serializable {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RestoreController.class.getName());
    long restoreDateFrom;
    long restoreDateTo;
    String restoreSizeUnit = null;
    ItemCollection metaData = null;
    protected List<ItemCollection> options = null;
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Inject
    RestoreService restoreService;
    @Inject
    MessageService messageService;

    @PostConstruct
    void init() {
        this.reset();
    }

    public void reset() {
        try {
            this.metaData = this.dataService.loadMetadata();
            this.options = this.restoreService.getOptions(this.metaData);
        }
        catch (ArchiveException e) {
            logger.severe("Failed to load meta data!");
            e.printStackTrace();
        }
    }

    public String getRestoreFrom() {
        SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
        return dt.format(this.restoreDateFrom);
    }

    public void setRestoreFrom(String restorePoint) throws ParseException {
        if (restorePoint != null && !restorePoint.isEmpty()) {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            try {
                this.restoreDateFrom = dt.parse(restorePoint).getTime();
            }
            catch (ParseException e) {
                logger.severe("Unable to parse syncdate: " + e.getMessage());
            }
        }
    }

    public String getRestoreTo() {
        if (this.restoreDateTo == 0L) {
            this.restoreDateTo = new Date().getTime();
            this.restoreDateTo += 1000L;
        }
        SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
        return dt.format(this.restoreDateTo);
    }

    public void setRestoreTo(String restorePoint) {
        if (restorePoint != null && !restorePoint.isEmpty()) {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            try {
                this.restoreDateTo = dt.parse(restorePoint).getTime();
            }
            catch (ParseException e) {
                logger.severe("Unable to parse syncdate: " + e.getMessage());
            }
        }
    }

    public Date getRestoreSyncPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("restore.point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public long getRestoreCount() {
        return this.metaData.getItemValueLong("restore.count");
    }

    public long getRestoreErrors() {
        return this.metaData.getItemValueLong("restore.errors");
    }

    public String getRestoreSize() {
        long l = this.metaData.getItemValueLong("restore.size");
        String result = this.messageService.userFriendlyBytes(l);
        String[] parts = result.split(" ");
        this.restoreSizeUnit = parts[1];
        return parts[0];
    }

    public String getRestoreSizeUnit() {
        return this.restoreSizeUnit;
    }

    public long getSyncPoint() {
        return this.metaData.getItemValueLong("sync.point");
    }

    public String getSyncPointISO() {
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date date = new Date(this.getSyncPoint());
        return dt.format(date);
    }

    public void startRestore() {
        try {
            logger.info("......init restore process: " + this.getRestoreFrom() + " to " + this.getRestoreTo());
            this.restoreService.setOptions(this.options, this.metaData);
            this.restoreService.start(this.restoreDateFrom, this.restoreDateTo, this.metaData.getItemValue("restore.options"));
        }
        catch (ArchiveException e) {
            logger.severe("failed to start restore process: " + e.getMessage());
        }
    }

    public void stopRestore() {
        try {
            this.restoreService.cancel();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        Timer timer = this.restoreService.findTimer();
        return timer != null;
    }

    public List<String> getMessages() {
        return this.messageService.getMessages("restore");
    }

    public List<ItemCollection> getOptions() {
        return this.options;
    }

    public void setOptions(List<ItemCollection> options) {
        this.options = options;
    }

    public void addOption() {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        ItemCollection itemCol = new ItemCollection();
        itemCol.replaceItemValue("type", (Object)"filter");
        this.options.add(itemCol);
    }

    public void removeOption(String optionName) {
        if (this.options != null) {
            int iPos = 0;
            for (ItemCollection item : this.options) {
                if (optionName.equals(item.getItemValueString("name"))) {
                    this.options.remove(iPos);
                    break;
                }
                ++iPos;
            }
        }
    }
}

