/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.ResyncService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ResyncController
implements Serializable {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ResyncController.class.getName());
    ItemCollection metaData = null;
    String newSyncPoint = null;
    @Inject
    ClusterService clusterService;
    @Inject
    ResyncService resyncService;
    @Inject
    DataService dataService;
    @Inject
    MessageService messageService;

    @PostConstruct
    void init() {
        try {
            this.metaData = this.dataService.loadMetadata();
        }
        catch (ArchiveException e) {
            logger.severe("Failed to load meta data!");
            e.printStackTrace();
        }
    }

    public String getNewSyncPoint() {
        if (this.newSyncPoint == null) {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            this.newSyncPoint = dt.format(this.getSyncPoint());
        }
        return this.newSyncPoint;
    }

    public void setNewSyncPoint(String newSyncPoint) {
        this.newSyncPoint = newSyncPoint;
    }

    public Date getSyncPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("sync.point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public void updateSyncPoint() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            Date syncDate = dt.parse(this.newSyncPoint);
            logger.info("......updateing syncpoint=" + this.newSyncPoint);
            this.metaData.setItemValue("sync.point", (Object)syncDate.getTime());
            this.dataService.saveMetadata(this.metaData);
            if (!this.resyncService.isRunning()) {
                this.resyncService.start();
            }
        }
        catch (ParseException | ArchiveException e) {
            logger.severe("failed to set new syncpoint: " + e.getMessage());
        }
    }

    public boolean isRunning() {
        return this.resyncService.isRunning();
    }

    public void cancel() {
        try {
            this.resyncService.cancel();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }
}

