/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.util;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.Singleton;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@Singleton
public class MessageService {
    private static final int MAX_COUNT = 32;
    private Map<String, List<String>> messageLog;
    private static Logger logger = Logger.getLogger(MessageService.class.getName());

    @PostConstruct
    void init() {
        this.messageLog = new HashMap();
    }

    public List<String> getMessages(String topic) {
        ArrayList messages = (ArrayList)this.messageLog.get(topic);
        if (messages == null) {
            messages = new ArrayList();
        }
        return messages;
    }

    public void logMessage(String topic, String message) {
        logger.info(topic + " => " + (String)message);
        SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
        message = dateFormatDE.format(new Date()) + " : " + (String)message;
        List messages = this.getMessages(topic);
        messages.add(message);
        while (messages.size() > 32) {
            messages.remove(0);
        }
        this.messageLog.put(topic, messages);
    }

    public String userFriendlyBytes(long bytes) {
        int unit;
        boolean si = true;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

