/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.resync;

import jakarta.annotation.Resource;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.RemoteAPIService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.ResyncStatusHandler;
import org.imixs.archive.service.util.MessageService;
import org.imixs.archive.service.util.RestClientHelper;
import org.imixs.melman.DocumentClient;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class ResyncService {
    public static final String TIMER_ID_SYNCSERVICE = "IMIXS_ARCHIVE_RESYNC_TIMER";
    public static final String ITEM_SYNCPOINT = "sync.point";
    public static final String ITEM_SYNCCOUNT = "sync.count";
    public static final String ITEM_SYNCSIZE = "sync.size";
    public static final String DEFAULT_SCHEDULER_DEFINITION = "hour=*";
    public static final String MESSAGE_TOPIC = "sync";
    private static final int MAX_COUNT = 500;
    @Resource
    TimerService timerService;
    @Inject
    DataService dataService;
    @Inject
    ClusterService clusterService;
    @Inject
    MessageService messageService;
    @Inject
    RemoteAPIService remoteAPIService;
    @Inject
    ResyncStatusHandler syncStatusHandler;
    @Inject
    RestClientHelper restClientHelper;
    private static Logger logger = Logger.getLogger(ResyncService.class.getName());

    public void start() throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage("sync", "Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(ResyncService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        if (this.clusterService.getSession() != null) {
            logger.finest("...starting scheduler sync-service ...");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)"IMIXS_ARCHIVE_RESYNC_TIMER"));
            timer = this.timerService.createSingleActionTimer(0L, timerConfig);
            if (timer != null) {
                this.messageService.logMessage("sync", "Timer started.");
            }
        } else {
            logger.warning("...Failed to initalize imixs-archive keyspace!");
        }
    }

    public void cancel() throws ArchiveException {
        this.syncStatusHandler.setStatus((byte)2);
        this.messageService.logMessage("sync", "... sync canceled!");
        this.stop(this.findTimer());
    }

    public boolean isRunning() {
        return this.findTimer() != null;
    }

    private void stop(Timer timer) throws ArchiveException {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                this.messageService.logMessage("sync", "Failed to stop timer - " + e.getMessage());
            }
            this.messageService.logMessage("sync", "Timer stopped. ");
        }
    }

    private Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!"IMIXS_ARCHIVE_RESYNC_TIMER".equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    @Timeout
    void onTimeout(Timer timer) throws Exception {
        long syncPoint = 0L;
        int syncUpdates = 0;
        int syncBlockRead = 0;
        int syncTotalRead = 0;
        long totalCount = 0L;
        long totalSize = 0L;
        ItemCollection metaData = null;
        String lastUniqueID = null;
        long lProfiler = System.currentTimeMillis();
        try {
            block10: {
                block9: {
                    DocumentClient documentClient = this.restClientHelper.createDocumentClient();
                    metaData = this.dataService.loadMetadata();
                    syncPoint = metaData.getItemValueLong("sync.point");
                    totalCount = metaData.getItemValueLong("sync.count");
                    totalSize = metaData.getItemValueLong("sync.size");
                    logger.info("...start synchronizing at syncPoint " + new Date(syncPoint) + "...");
                    Date now = new Date();
                    if (syncPoint > now.getTime()) {
                        logger.warning("...current syncpoint (" + syncPoint + ") is in the future! Adjust Syncpoint to now (" + now.getTime() + ")....");
                        syncPoint = now.getTime();
                    }
                    do {
                        long lReadTime = System.currentTimeMillis();
                        long lTotalTime = System.currentTimeMillis();
                        XMLDataCollection xmlDataCollection = this.remoteAPIService.readSyncData(syncPoint, documentClient);
                        if (xmlDataCollection == null) break block9;
                        logger.info("...found " + xmlDataCollection.getDocument().length + " snapshots at syncpoint " + new Date(syncPoint) + " in " + (System.currentTimeMillis() - lReadTime) + "ms");
                        List<XMLDocument> snapshotList = Arrays.asList(xmlDataCollection.getDocument());
                        for (XMLDocument xmlDocument : snapshotList) {
                            long lSyncTime = System.currentTimeMillis();
                            ItemCollection snapshot = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
                            Date syncpointdate = snapshot.getItemValueDate("$modified");
                            syncPoint = syncpointdate.getTime();
                            logger.fine("......data found - new syncpoint=" + syncPoint);
                            if (!this.dataService.existSnapshot(snapshot.getUniqueID())) {
                                try {
                                    lastUniqueID = snapshot.getUniqueID();
                                    this.dataService.saveSnapshot(snapshot);
                                    ++syncUpdates;
                                    ++totalCount;
                                    totalSize += this.dataService.calculateSize(xmlDocument);
                                }
                                catch (RuntimeException e) {
                                    logger.warning("Failed to resync snapshot id '" + snapshot.getUniqueID() + "' - error: " + e.getMessage());
                                }
                                logger.info("...snapshot '" + snapshot.getUniqueID() + "' written in  " + (System.currentTimeMillis() - lSyncTime) + "ms");
                            } else {
                                logger.info("...snapshot '" + snapshot.getUniqueID() + "' already exits - verification took " + (System.currentTimeMillis() - lSyncTime) + "ms");
                            }
                            ++syncBlockRead;
                            ++syncTotalRead;
                            metaData.setItemValue("sync.point", (Object)syncPoint);
                            metaData.setItemValue("sync.count", (Object)totalCount);
                            metaData.setItemValue("sync.size", (Object)totalSize);
                            lastUniqueID = "0";
                            this.dataService.saveMetadata(metaData);
                            logger.info("...snapshot '" + snapshot.getUniqueID() + "' synchronized in " + (System.currentTimeMillis() - lTotalTime) + "ms");
                            if (this.syncStatusHandler.getStatus() != 2) continue;
                            break;
                        }
                        if (syncBlockRead < 500) continue;
                        this.messageService.logMessage("sync", "... " + syncTotalRead + " snapshots verified (" + syncUpdates + " updates) in: " + ResyncService.formatDuration((long)(System.currentTimeMillis() - lProfiler)) + " , next syncpoint " + new Date(syncPoint));
                        syncBlockRead = 0;
                    } while (this.syncStatusHandler.getStatus() != 2);
                    break block10;
                }
                logger.finest("......no more data found for syncpoint: " + syncPoint);
            }
            this.messageService.logMessage("sync", "...no more data found at syncpoint " + new Date(syncPoint) + " -> finishing synchroization.");
            this.stop(timer);
        }
        catch (RuntimeException | ArchiveException e) {
            e.printStackTrace();
            this.messageService.logMessage("sync", "sync failed " + (String)("0".equals(lastUniqueID) ? " (failed to save metadata)" : "(last uniqueid=" + lastUniqueID + ")") + " : " + e.getMessage());
            this.stop(timer);
        }
    }

    private static String formatDuration(long durationInMillis) {
        long durationInSeconds = durationInMillis / 1000L;
        long durationInMinutes = durationInSeconds / 60L;
        long durationInHours = durationInMinutes / 60L;
        String formattedDuration = durationInHours > 0L ? String.format("%d hours, %d minutes und %d seconds", durationInHours, durationInMinutes % 60L, durationInSeconds % 60L) : (durationInMinutes > 0L ? String.format("%d minutes and %d seconds", durationInMinutes, durationInSeconds % 60L) : String.format("%d seconds", durationInSeconds));
        return formattedDuration;
    }
}

