/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.util;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Cookie;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.CookieAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.JWTAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;

@Named
@ApplicationScoped
public class RestClientHelper
implements Serializable {
    private static Logger logger = Logger.getLogger(RestClientHelper.class.getName());
    private static final long serialVersionUID = 1L;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> instanceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> instanceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> instancePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> instanceAuthmethod;
    DocumentClient documentClient = null;
    EventLogClient eventLogClient = null;

    public DocumentClient createDocumentClient() throws RestAPIException {
        if (this.documentClient != null) {
            return this.documentClient;
        }
        logger.info("RestClientHelper create DocumentClient....");
        if (this.instanceEndpoint.isPresent()) {
            this.documentClient = new WorkflowClient((String)this.instanceEndpoint.get());
            String auttype = this.instanceAuthmethod.orElse("BASIC").toUpperCase();
            if ("BASIC".equals(auttype)) {
                BasicAuthenticator basicAuth = new BasicAuthenticator(this.instanceUser.orElse(""), this.instancePassword.orElse(""));
                this.documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
            }
            if ("FORM".equals(auttype)) {
                logger.info("RestClientHelper create FormAuthenticator.... instance endpoint=" + this.instanceEndpoint.orElse(""));
                FormAuthenticator formAuth = new FormAuthenticator(this.instanceEndpoint.orElse(""), this.instanceUser.orElse(""), this.instancePassword.orElse(""));
                this.documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
            }
            if ("COOKIE".equals(auttype)) {
                Cookie cookie = ((Cookie.Builder)((Cookie.Builder)new Cookie.Builder(this.instanceUser.orElse("")).path("/")).value(this.instancePassword.orElse(""))).build();
                CookieAuthenticator cookieAuth = new CookieAuthenticator(cookie);
                this.documentClient.registerClientRequestFilter((ClientRequestFilter)cookieAuth);
            }
            if ("JWT".equalsIgnoreCase(this.instancePassword.orElse(""))) {
                JWTAuthenticator jwtAuht = new JWTAuthenticator(this.instancePassword.orElse(""));
                this.documentClient.registerClientRequestFilter((ClientRequestFilter)jwtAuht);
            }
        }
        return this.documentClient;
    }

    public EventLogClient createEventLogClient(DocumentClient documentClient) {
        if (this.eventLogClient != null) {
            return this.eventLogClient;
        }
        if (documentClient != null) {
            EventLogClient client = new EventLogClient(documentClient.getBaseURI());
            List filterList = documentClient.getRequestFilterList();
            for (ClientRequestFilter filter : filterList) {
                client.registerClientRequestFilter(filter);
            }
            return client;
        }
        return null;
    }

    public void reset() {
        this.documentClient = null;
        this.eventLogClient = null;
    }
}

