/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.api;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.logging.Logger;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;

@Path(value="/metadata")
@Produces(value={"application/json", "text/html", "text/xml"})
@Stateless
public class MetatdataRestService {
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    public String getSyncpoint() {
        Object session = null;
        Object cluster = null;
        try {
            logger.info("...read metadata...");
            ItemCollection metadata = this.dataService.loadMetadata();
            String result = "syncpoint=" + metadata.getItemValueString("sync.point");
            String string = result = result + "\ncount=" + metadata.getItemValueString("sync.count");
            return string;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            String string = "NO DATA";
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    static {
        logger = Logger.getLogger(MetatdataRestService.class.getName());
    }
}

