/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ArchiveEvent;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DocumentSplitter;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class DataService {
    public static final String ITEM_MD5_CHECKSUM = "md5checksum";
    public static final String ITEM_SNAPSHOT_HISTORY = "$snapshot.history";
    private static final String REGEX_SNAPSHOTID = "([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}-[0-9]{13,15})";
    private static final String REGEX_OLD_SNAPSHOTID = "([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)";
    private static Logger logger = Logger.getLogger(DataService.class.getName());
    public static final String COLUMN_SNAPSHOT = "snapshot";
    public static final String COLUMN_MODIFIED = "modified";
    public static final String COLUMN_UNIQUEID = "uniqueid";
    public static final String COLUMN_DATA = "data";
    public static final String COLUMN_MD5 = "md5";
    public static final String STATEMENT_UPSET_SNAPSHOTS = "insert into snapshots (snapshot, data) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_UNIQUEID = "insert into snapshots_by_uniqueid (uniqueid, snapshot) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_MODIFIED = "insert into snapshots_by_modified (modified, snapshot) values (?, ?)";
    public static final String STATEMENT_UPSET_DOCUMENTS = "insert into documents (md5, sort_id, data_id) values (?, ?, ?)";
    public static final String STATEMENT_UPSET_DOCUMENTS_DATA = "insert into documents_data (data_id, data) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_DOCUMENT = "insert into snapshots_by_document (md5, snapshot) values (?, ?)";
    public static final String STATEMENT_SELECT_SNAPSHOT = "select * from snapshots where snapshot='?'";
    public static final String STATEMENT_SELECT_METADATA = "select * from snapshots where snapshot='0'";
    public static final String STATEMENT_SELECT_SNAPSHOT_ID = "select snapshot from snapshots where snapshot='?'";
    public static final String STATEMENT_SELECT_MD5 = "select md5 from documents where md5='?'";
    public static final String STATEMENT_SELECT_DOCUMENTS = "select * from documents where md5='?'";
    public static final String STATEMENT_SELECT_DOCUMENTS_DATA = "select * from documents_data where data_id='?'";
    public static final String STATEMENT_SELECT_SNAPSHOTS_BY_DOCUMENT = "select * from snapshots_by_document where md5='?'";
    public static final String STATEMENT_SELECT_SNAPSHOTS_BY_UNIQUEID = "select * from snapshots_by_uniqueid where uniqueid='?'";
    public static final String STATEMENT_SELECT_SNAPSHOTS_BY_MODIFIED = "select * from snapshots_by_modified where modified='?'";
    public static final String STATEMENT_DELETE_SNAPSHOTS = "delete from snapshots where snapshot='<snapshot>'";
    public static final String STATEMENT_DELETE_SNAPSHOTS_BY_MODIFIED = "delete from snapshots_by_modified where modified='<modified>' and snapshot='<snapshot>'";
    public static final String STATEMENT_DELETE_SNAPSHOTS_BY_UNIQUEID = "delete from snapshots_by_uniqueid where uniqueid='<uniqueid>' and snapshot='<snapshot>'";
    public static final String STATEMENT_DELETE_SNAPSHOTS_BY_DOCUMENT = "delete from snapshots_by_document where md5='<md5>' and snapshot='<snapshot>'";
    public static final String STATEMENT_DELETE_DOCUMENTS_DATA = "delete from documents_data where data_id='<data_id>'";
    public static final String STATEMENT_DELETE_DOCUMENTS = "delete from documents where md5='<md5>' and sort_id=<sort_id>";
    @Inject
    ClusterService clusterService;
    @Inject
    protected Event<ArchiveEvent> events;

    public void saveSnapshot(ItemCollection snapshot) throws ArchiveException {
        boolean debug = logger.isLoggable(Level.FINE);
        String snapshotID = snapshot.getUniqueID();
        if (!this.isSnapshotID(snapshotID)) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", "unexpected '$snapshotid' format: '" + snapshotID + "'");
        }
        if (debug) {
            logger.finest("......save document" + snapshotID);
        }
        if (!snapshot.hasItem("$modified")) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", "missing item '$modified' for snapshot " + snapshotID);
        }
        if (this.existSnapshot(snapshotID)) {
            logger.fine("...snapshot '" + snapshot.getUniqueID() + "' already exits....");
            return;
        }
        String originUnqiueID = this.getUniqueID(snapshotID);
        this.extractDocuments(snapshot);
        this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_SNAPSHOTS, new Object[]{snapshot.getUniqueID(), ByteBuffer.wrap(this.getRawData(snapshot))}));
        this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_SNAPSHOTS_BY_UNIQUEID, new Object[]{originUnqiueID, snapshot.getUniqueID()}));
        com.datastax.driver.core.LocalDate ld = com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)snapshot.getItemValueDate("$modified").getTime());
        this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_SNAPSHOTS_BY_MODIFIED, new Object[]{ld, snapshot.getUniqueID()}));
        this.cleanupSnaphostHistory(snapshot);
        if (this.events != null) {
            this.events.fire((Object)new ArchiveEvent(snapshot, 1));
        } else {
            logger.warning("Missing CDI support for Event<ArchiveEvent> !");
        }
    }

    public boolean existSnapshot(String snapshotID) {
        String sql = STATEMENT_SELECT_SNAPSHOT_ID;
        sql = sql.replace("'?'", "'" + snapshotID + "'");
        logger.finest("......search snapshot id: " + sql);
        ResultSet rs = this.clusterService.getSession().execute(sql);
        Row row = rs.one();
        return row != null;
    }

    public ItemCollection loadSnapshot(String snapshotID) throws ArchiveException {
        return this.loadSnapshot(snapshotID, true);
    }

    public ItemCollection loadSnapshot(String snapshotID, boolean mergeDocuments) throws ArchiveException {
        ResultSet rs;
        Row row;
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection snapshot = new ItemCollection();
        String sql = STATEMENT_SELECT_SNAPSHOT;
        sql = sql.replace("'?'", "'" + snapshotID + "'");
        if (debug) {
            logger.finest("......search snapshot id: " + sql);
        }
        if ((row = (rs = this.clusterService.getSession().execute(sql)).one()) != null) {
            ByteBuffer data = row.getBytes(COLUMN_DATA);
            if (data != null && data.hasArray()) {
                snapshot = this.getItemCollection(data.array());
                this.mergeDocumentData(snapshot);
            } else {
                logger.warning("no data found for snapshotId '" + snapshotID + "'");
            }
        } else {
            snapshot = new ItemCollection();
        }
        return snapshot;
    }

    public List<String> loadSnapshotsByUnqiueID(String uniqueID, int maxCount, boolean descending) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        Object sql = STATEMENT_SELECT_SNAPSHOTS_BY_UNIQUEID;
        if (descending) {
            sql = (String)sql + " ORDER BY snapshot DESC";
        }
        if (maxCount > 0) {
            sql = (String)sql + " LIMIT " + maxCount;
        }
        sql = ((String)sql).replace("'?'", "'" + uniqueID + "'");
        if (debug) {
            logger.finest("......search snapshot id: " + (String)sql);
        }
        ResultSet rs = this.clusterService.getSession().execute((String)sql);
        for (Row row : rs) {
            String snapshotID = row.getString(1);
            result.add(snapshotID);
        }
        return result;
    }

    public List<String> loadSnapshotsByDate(LocalDate date) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        String sql = STATEMENT_SELECT_SNAPSHOTS_BY_MODIFIED;
        sql = sql.replace("'?'", "'" + String.valueOf(date) + "'");
        if (debug) {
            logger.finest("......SQL: " + sql);
        }
        ResultSet rs = this.clusterService.getSession().execute(sql);
        for (Row row : rs) {
            String snapshotID = row.getString(1);
            result.add(snapshotID);
        }
        return result;
    }

    public FileData loadFileData(FileData fileData) throws ArchiveException {
        ItemCollection customAttributes = new ItemCollection(fileData.getAttributes());
        String md5 = customAttributes.getItemValueString(ITEM_MD5_CHECKSUM);
        byte[] allData = this.loadFileContent(md5);
        if (allData == null) {
            return null;
        }
        return new FileData(fileData.getName(), allData, fileData.getContentType(), fileData.getAttributes());
    }

    public byte[] loadFileContent(String md5) throws ArchiveException {
        if (md5 == null || md5.isEmpty()) {
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        String sql = STATEMENT_SELECT_DOCUMENTS;
        sql = sql.replace("'?'", "'" + md5 + "'");
        if (debug) {
            logger.finest("......search MD5 entry: " + sql);
        }
        ResultSet rs = this.clusterService.getSession().execute(sql);
        Iterator resultIter = rs.iterator();
        ByteArrayOutputStream bOutput = new ByteArrayOutputStream(0x100000);
        try {
            while (resultIter.hasNext()) {
                Row row = (Row)resultIter.next();
                int sort_id = row.getInt(1);
                String data_id = row.getString(2);
                if (debug) {
                    logger.finest("......load 1mb data block: sort_id=" + sort_id + " data_id=" + data_id);
                }
                String sql_data = STATEMENT_SELECT_DOCUMENTS_DATA;
                sql_data = sql_data.replace("'?'", "'" + data_id + "'");
                ResultSet rs_data = this.clusterService.getSession().execute(sql_data);
                Row row_data = rs_data.one();
                if (row_data != null) {
                    if (debug) {
                        logger.finest("......merge data block: " + md5 + " sort_id: " + sort_id + " data_id: " + data_id + "...");
                    }
                    ByteBuffer byteDataBlock = row_data.getBytes(1);
                    bOutput.write(byteDataBlock.array());
                    continue;
                }
                logger.warning("Document Data missing:  MD5:" + md5 + " sort_id: " + sort_id + " data_id: " + data_id);
            }
            byte[] allData = bOutput.toByteArray();
            if (debug) {
                logger.finest("......collected full data block: " + md5 + " size: " + allData.length + "...");
            }
            byte[] byArray = allData;
            return byArray;
        }
        catch (IOException e) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", "failed to load document data: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (bOutput != null) {
                try {
                    bOutput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ItemCollection loadMetadata() throws ArchiveException {
        return this.loadSnapshot("0");
    }

    public void saveMetadata(ItemCollection metadata) throws ArchiveException {
        this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_SNAPSHOTS, new Object[]{"0", ByteBuffer.wrap(this.getRawData(metadata))}));
    }

    public void deleteSnapshot(String snapshotID) throws ArchiveException {
        logger.finest("......delete snapshot and documents for:" + snapshotID);
        String uniqueID = this.getUniqueID(snapshotID);
        ItemCollection snapshot = this.loadSnapshot(snapshotID, false);
        String sql = STATEMENT_DELETE_SNAPSHOTS;
        sql = sql.replace("'<snapshot>'", "'" + snapshotID + "'");
        this.clusterService.getSession().execute(sql);
        sql = STATEMENT_DELETE_SNAPSHOTS_BY_UNIQUEID;
        sql = sql.replace("'<uniqueid>'", "'" + uniqueID + "'");
        sql = sql.replace("'<snapshot>'", "'" + snapshotID + "'");
        this.clusterService.getSession().execute(sql);
        long modifiedTime = 0L;
        if (snapshot != null) {
            Date modified = null;
            modified = snapshot.getItemValueDate("$modified");
            if (modified == null) {
                logger.warning("Snapshot Object '" + snapshotID + "' has no '$modified' item!");
                modifiedTime = this.getSnapshotTime(snapshotID);
            } else {
                modifiedTime = modified.getTime();
            }
        } else {
            logger.warning("Snapshot Object '" + snapshotID + "' not found in archive!");
        }
        com.datastax.driver.core.LocalDate ld = com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)modifiedTime);
        sql = STATEMENT_DELETE_SNAPSHOTS_BY_MODIFIED;
        sql = sql.replace("'<modified>'", "'" + String.valueOf(ld) + "'");
        sql = sql.replace("'<snapshot>'", "'" + snapshotID + "'");
        this.clusterService.getSession().execute(sql);
        this.deleteDocuments(snapshot);
    }

    public byte[] getRawData(ItemCollection itemCol) throws ArchiveException {
        byte[] data = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Marshaller m = context.createMarshaller();
            XMLDocument xmlDocument = XMLDocumentAdapter.getDocument((ItemCollection)itemCol);
            m.marshal((Object)xmlDocument, (OutputStream)outputStream);
            data = outputStream.toByteArray();
        }
        catch (JAXBException e) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", e.getMessage(), (Exception)((Object)e));
        }
        return data;
    }

    public ItemCollection getItemCollection(byte[] source) throws ArchiveException {
        ByteArrayInputStream bis = new ByteArrayInputStream(source);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Unmarshaller m = context.createUnmarshaller();
            Object jaxbObject = m.unmarshal((InputStream)bis);
            if (jaxbObject == null) {
                throw new RuntimeException("readCollection error - wrong xml file format - unable to read content!");
            }
            XMLDocument xmlDocument = (XMLDocument)jaxbObject;
            return XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
        }
        catch (JAXBException e) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean isSnapshotID(String uid) {
        boolean valid = uid.matches(REGEX_SNAPSHOTID);
        boolean debug = logger.isLoggable(Level.FINE);
        if (!valid) {
            if (debug) {
                logger.fine("...validate old snapshot id format...");
            }
            valid = uid.matches(REGEX_OLD_SNAPSHOTID);
        }
        return valid;
    }

    public String getUniqueID(String snapshotID) {
        if (snapshotID != null && snapshotID.contains("-")) {
            return snapshotID.substring(0, snapshotID.lastIndexOf("-"));
        }
        return null;
    }

    public long getSnapshotTime(String snapshotID) {
        if (snapshotID != null && snapshotID.contains("-")) {
            String sTime = snapshotID.substring(snapshotID.lastIndexOf("-") + 1);
            return Long.parseLong(sTime);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateSize(XMLDocument xmldoc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(xmldoc);
            oos.close();
            long l = baos.size();
            return l;
        }
        catch (IOException e) {
            logger.warning("...unable to calculate document size!");
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    logger.warning("failed to close stream");
                    e.printStackTrace();
                }
            }
        }
        return 0L;
    }

    public String getSyncPointISO(long point) {
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date date = new Date(point);
        return dt.format(date);
    }

    private void cleanupSnaphostHistory(ItemCollection snapshot) throws ArchiveException {
        boolean debug = logger.isLoggable(Level.FINE);
        int snapshotHistory = snapshot.getItemValueInteger(ITEM_SNAPSHOT_HISTORY);
        if (snapshotHistory > 0) {
            if (debug) {
                logger.finest("......$snapshot.history=" + snapshotHistory);
            }
            String uniqueid = this.getUniqueID(snapshot.getUniqueID());
            Object sql = STATEMENT_SELECT_SNAPSHOTS_BY_UNIQUEID;
            sql = (String)sql + " ORDER BY snapshot DESC";
            sql = (String)sql + " LIMIT " + (snapshotHistory + 1);
            sql = ((String)sql).replace("'?'", "'" + uniqueid + "'");
            if (debug) {
                logger.finest("......search snapshots for id: " + (String)sql);
            }
            ResultSet rs = this.clusterService.getSession().execute((String)sql);
            Iterator resultIter = rs.iterator();
            int snapshotcount = 0;
            String lastestSnapshotID = null;
            while (resultIter.hasNext()) {
                Row row = (Row)resultIter.next();
                lastestSnapshotID = row.getString(1);
                ++snapshotcount;
            }
            if (snapshotcount < snapshotHistory) {
                return;
            }
            sql = STATEMENT_SELECT_SNAPSHOTS_BY_UNIQUEID;
            sql = (String)sql + " AND snapshot<='" + lastestSnapshotID + "'";
            sql = (String)sql + " ORDER BY snapshot ASC";
            sql = (String)sql + " LIMIT 100";
            sql = ((String)sql).replace("'?'", "'" + uniqueid + "'");
            if (debug) {
                logger.finest("......search snapshot id: " + (String)sql);
            }
            rs = this.clusterService.getSession().execute((String)sql);
            int deletions = 0;
            for (Row row : rs) {
                String id = row.getString(1);
                this.deleteSnapshot(id);
                ++deletions;
            }
            if (deletions >= 2) {
                logger.info("...deleted " + deletions + " deprecated snapshots form history (" + uniqueid + ")");
            }
        }
    }

    private void extractDocuments(ItemCollection itemCol) throws ArchiveException {
        boolean debug = logger.isLoggable(Level.FINE);
        byte[] empty = new byte[]{};
        List files = itemCol.getFileData();
        for (FileData fileData : files) {
            try {
                ResultSet rs;
                Row row;
                if (debug) {
                    logger.finest("... extract fileData objects: " + files.size() + " fileData objects found....");
                }
                if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
                String md5 = fileData.generateMD5();
                String sql = STATEMENT_SELECT_MD5;
                sql = sql.replace("'?'", "'" + md5 + "'");
                if (debug) {
                    logger.finest("......search MD5 entry: " + sql);
                }
                if ((row = (rs = this.clusterService.getSession().execute(sql)).one()) == null) {
                    this.storeDocument(md5, fileData.getContent());
                } else if (debug) {
                    logger.finest("......update fildata not necessary because object: " + md5 + " is already stored!");
                }
                this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_SNAPSHOTS_BY_DOCUMENT, new Object[]{md5, itemCol.getUniqueID()}));
                if (debug) {
                    logger.finest("drop content for file '" + fileData.getName() + "'");
                }
                itemCol.addFileData(new FileData(fileData.getName(), empty, fileData.getContentType(), fileData.getAttributes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new ArchiveException("MD5_ERROR", "can not compute md5 of document - " + e.getMessage());
            }
        }
    }

    private void deleteDocuments(ItemCollection itemCol) throws ArchiveException {
        if (itemCol == null) {
            return;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        List files = itemCol.getFileData();
        for (FileData fileData : files) {
            try {
                ResultSet rs;
                Iterator resultIter;
                if (debug) {
                    logger.finest("......delete fileData ref and objects: " + files.size() + " fileData objects found....");
                }
                if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
                String md5 = fileData.generateMD5();
                String sql = STATEMENT_DELETE_SNAPSHOTS_BY_DOCUMENT;
                sql = sql.replace("'<md5>'", "'" + md5 + "'");
                sql = sql.replace("'<snapshot>'", "'" + itemCol.getUniqueID() + "'");
                this.clusterService.getSession().execute(sql);
                sql = STATEMENT_SELECT_SNAPSHOTS_BY_DOCUMENT;
                sql = sql.replace("'?'", "'" + md5 + "'");
                if (debug) {
                    logger.finest("......SQL: " + sql);
                }
                if ((resultIter = (rs = this.clusterService.getSession().execute(sql)).iterator()).hasNext()) {
                    return;
                }
                String sql_sub = STATEMENT_SELECT_DOCUMENTS;
                sql_sub = sql_sub.replace("'?'", "'" + md5 + "'");
                if (debug) {
                    logger.finest("......search MD5 entry: " + sql_sub);
                }
                ResultSet rs_sub = this.clusterService.getSession().execute(sql_sub);
                Iterator resultIterSub = rs_sub.iterator();
                ArrayList<String> dataIDs = new ArrayList<String>();
                ArrayList<Integer> sortIDs = new ArrayList<Integer>();
                while (resultIterSub.hasNext()) {
                    Row row = (Row)resultIterSub.next();
                    int sort_id = row.getInt(1);
                    String data_id = row.getString(2);
                    logger.info("......delete 1mb data block: sort_id=" + sort_id + " data_id=" + data_id);
                    dataIDs.add(data_id);
                    sortIDs.add(sort_id);
                }
                for (String data_id : dataIDs) {
                    sql = STATEMENT_DELETE_DOCUMENTS_DATA;
                    sql = sql.replace("<data_id>", data_id);
                    this.clusterService.getSession().execute(sql);
                }
                Iterator iterator = sortIDs.iterator();
                while (iterator.hasNext()) {
                    int sort_id = (Integer)iterator.next();
                    sql = STATEMENT_DELETE_DOCUMENTS;
                    sql = sql.replace("<md5>", md5);
                    sql = sql.replace("<sort_id>", Integer.toString(sort_id));
                    this.clusterService.getSession().execute(sql);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new ArchiveException("MD5_ERROR", "can not compute md5 of document - " + e.getMessage());
            }
        }
    }

    private void storeDocument(String md5, byte[] data) {
        boolean debug = logger.isLoggable(Level.FINE);
        DocumentSplitter documentSplitter = new DocumentSplitter(data);
        Iterator it = documentSplitter.iterator();
        int sort_id = 0;
        while (it.hasNext()) {
            String data_id = WorkflowKernel.generateUniqueID();
            if (debug) {
                logger.finest("......write new 1mb data block: sort_id=" + sort_id + " data_id=" + data_id);
            }
            byte[] chunk = (byte[])it.next();
            this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_DOCUMENTS_DATA, new Object[]{data_id, ByteBuffer.wrap(chunk)}));
            this.clusterService.getSession().execute((Statement)new SimpleStatement(STATEMENT_UPSET_DOCUMENTS, new Object[]{md5, sort_id, data_id}));
            ++sort_id;
        }
        if (debug) {
            logger.finest("......stored filedata object: " + md5);
        }
    }

    private void mergeDocumentData(ItemCollection itemCol) throws ArchiveException {
        boolean debug = logger.isLoggable(Level.FINE);
        List files = itemCol.getFileData();
        for (FileData fileData : files) {
            if (debug) {
                logger.finest("... merge fileData objects: " + files.size() + " fileData objects defined....");
            }
            if (fileData.getContent() != null && fileData.getContent().length != 0) continue;
            fileData = this.loadFileData(fileData);
            itemCol.addFileData(fileData);
        }
    }
}

