/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.util;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.imixs.melman.RestAPIException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;

public class KeycloakAuthenticator
implements ClientRequestFilter {
    private String token = null;
    public static final String KEYCLOAK_ENDPOINT = "keycloak.endpoint";
    public static final String KEYCLOAK_REALM = "keycloak.realm";
    public static final String KEYCLOAK_CLIENTID = "keycloak.clientid";
    public static final String KEYCLOAK_SECRET = "keycloak.secret";
    private static final Logger logger = Logger.getLogger(KeycloakAuthenticator.class.getName());
    String keycloakServer;
    String keycloakRealm;
    String keycloakClientId;
    String keycloakSecret;

    public KeycloakAuthenticator(String _baseUri, String username, String password) throws RestAPIException {
        boolean debug = logger.isLoggable(Level.FINE);
        logger.info("init KeycloakAuthenticator... (v2)");
        this.readConfig();
        debug = true;
        if (debug) {
            logger.info("keycloak login: " + _baseUri);
        }
        Configuration configuration = new Configuration(this.keycloakServer, this.keycloakRealm, this.keycloakClientId, Collections.singletonMap("secret", this.keycloakSecret), (HttpClient)HttpClients.createDefault());
        AuthzClient authzClient = AuthzClient.create((Configuration)configuration);
        AuthorizationRequest request = new AuthorizationRequest();
        AuthorizationResponse response = authzClient.authorization(username, password).authorize(request);
        this.token = response.getToken();
        logger.info("token=" + this.token);
        try {
            AccessToken accessToken = (AccessToken)new JWSInput(this.token).readJsonContent(AccessToken.class);
            logger.info("---email=" + accessToken.getEmail());
        }
        catch (JWSInputException cause) {
            throw new IllegalArgumentException("Failed to deserialize token", cause);
        }
    }

    public void readConfig() {
        logger.info("read config KeycloakAuthenticator...");
        this.keycloakServer = System.getenv("KEYCLOAK_ENDPOINT");
        this.keycloakRealm = System.getenv("KEYCLOAK_REALM");
        this.keycloakClientId = System.getenv("KEYCLOAK_CLIENTID");
        this.keycloakSecret = System.getenv("KEYCLOAK_SECRET");
        logger.info("Keycloak Server: " + this.keycloakServer);
        logger.info("Keycloak Realm: " + this.keycloakRealm);
        logger.info("Keycloak ClientId: " + this.keycloakClientId);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.token != null && !"".equals(this.token)) {
            logger.info(" add authroization header....v2");
            requestContext.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.getToken()));
        }
    }
}

