/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class RemoteAPIService {
    public static final String SNAPSHOT_RESOURCE = "snapshot/";
    public static final String DOCUMENTS_RESOURCE = "documents/";
    public static final String SNAPSHOT_SYNCPOINT_RESOURCE = "snapshot/syncpoint/";
    private static Logger logger = Logger.getLogger(RemoteAPIService.class.getName());
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> workflowServicePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> workflowServiceAuthMethod;

    public XMLDataCollection readSyncData(long syncPoint, DocumentClient documentClient) throws ArchiveException {
        XMLDataCollection result = null;
        Object url = "";
        try {
            url = SNAPSHOT_SYNCPOINT_RESOURCE + syncPoint;
            logger.finest("...... read data: " + (String)url + "....");
            result = documentClient.getCustomResourceXML((String)url);
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed readSyncData at : " + (String)url + "  Error Message: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        if (result != null && result.getDocument().length > 0) {
            return result;
        }
        return null;
    }

    public String readSnapshotIDByUniqueID(String uniqueid, DocumentClient documentClient) throws ArchiveException {
        String result = null;
        try {
            String url = DOCUMENTS_RESOURCE + uniqueid + "?items=$snapshotid";
            logger.finest("...... read snapshotid: " + url + "....");
            XMLDataCollection xmlDocument = documentClient.getCustomResourceXML(url);
            if (xmlDocument != null && xmlDocument.getDocument().length > 0) {
                ItemCollection document = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument.getDocument()[0]);
                result = document.getItemValueString("$snapshotid");
            }
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to readSyncData : " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        return result;
    }

    public void restoreSnapshot(ItemCollection snapshot, DocumentClient documentClient) throws ArchiveException {
        try {
            String url = SNAPSHOT_RESOURCE;
            logger.finest("...... post data: " + url + "....");
            documentClient.postXMLDocument(url, XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to restoreSnapshot: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
    }

    public void deleteSnapshot(String id, DocumentClient documentClient) throws ArchiveException {
        try {
            String url = SNAPSHOT_RESOURCE;
            logger.finest("...... delete data: " + url + "....");
            documentClient.deleteDocument(id);
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to deleteSnapshot: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
    }
}

