/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.SyncService;
import org.imixs.archive.service.util.RestClientHelper;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;

@Startup
@Singleton
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SyncScheduler {
    @Inject
    @ConfigProperty(name="workflow.sync.interval", defaultValue="5000")
    long interval;
    @Inject
    @ConfigProperty(name="workflow.sync.initialdelay", defaultValue="30000")
    long initialDelay;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    SyncService archiveSyncService;
    @Resource
    TimerService timerService;
    @Inject
    RestClientHelper restClientHelper;
    private static Logger logger = Logger.getLogger(SyncScheduler.class.getName());

    @PostConstruct
    public void init() {
        if (this.workflowServiceEndpoint.isPresent()) {
            logger.info("Starting Archive SyncScheduler - initalDelay=" + this.initialDelay + "ms  inverval=" + this.interval + "ms ....");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)""));
            timerConfig.setPersistent(false);
            this.timerService.createIntervalTimer(this.initialDelay, this.interval, timerConfig);
        }
    }

    @Timeout
    public void run(Timer timer) {
        DocumentClient documentClient = null;
        EventLogClient eventLogClient = null;
        logger.fine("--- run timeout.... timerInfo= " + String.valueOf(timer.getInfo()));
        try {
            documentClient = this.restClientHelper.createDocumentClient();
            eventLogClient = this.restClientHelper.createEventLogClient(documentClient);
            if (documentClient != null) {
                logger.fine("--- process event log (Debug)....");
                this.archiveSyncService.releaseDeadLocks(eventLogClient);
                this.archiveSyncService.processEventLog(eventLogClient, documentClient);
                logger.fine("--- process event log completed.");
            } else {
                logger.warning("unable to connect: invalid connect configuration!");
            }
        }
        catch (NotFoundException | RestAPIException e) {
            logger.warning("unable to process event log: " + e.getMessage());
            e.printStackTrace();
            this.restClientHelper.reset();
            timer.cancel();
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)""));
            timerConfig.setPersistent(false);
            logger.warning("restarting sync in " + this.initialDelay + " ms...");
            this.timerService.createIntervalTimer(this.initialDelay, this.interval, timerConfig);
        }
    }
}

