/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import jakarta.ejb.EJBException;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.InvalidAccessException;

@Stateless
@LocalBean
public class SyncService {
    public static final String EVENTLOG_TOPIC_ADD = "snapshot.add";
    public static final String EVENTLOG_TOPIC_REMOVE = "snapshot.remove";
    public static final String EVENTLOG_TOPIC_BACKUP = "snapshot.backup";
    public static final String ITEM_BACKUPRESTORE = "$backuprestore";
    public static final String ENV_WORKFLOW_SERVICE_ENDPOINT = "workflow.service.endpoint";
    public static final String ENV_WORKFLOW_SERVICE_USER = "workflow.service.user";
    public static final String ENV_WORKFLOW_SERVICE_PASSWORD = "workflow.service.password";
    public static final String ENV_WORKFLOW_SERVICE_AUTHMETHOD = "workflow.service.authmethod";
    public static final String ENV_WORKFLOW_SYNC_INTERVAL = "workflow.sync.interval";
    public static final String ENV_WORKFLOW_SYNC_INITIALDELAY = "workflow.sync.initialdelay";
    public static final String ENV_WORKFLOW_SYNC_DEADLOCK = "workflow.sync.deadlock";
    public static final String ENV_BACKUP_SERVICE_ENDPOINT = "backup.service.endpoint";
    public static final String ENV_BACKUP_MIRRORS = "backup.mirrors";
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> workflowServicePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> workflowServiceAuthMethod;
    @Inject
    @ConfigProperty(name="workflow.sync.deadlock", defaultValue="60000")
    long deadLockInterval;
    @Inject
    @ConfigProperty(name="backup.service.endpoint")
    Optional<String> backupServiceEndpoint;
    @Inject
    @ConfigProperty(name="backup.mirrors")
    Optional<String> backupMirrors;
    @Inject
    DataService dataService;
    private static Logger logger = Logger.getLogger(SyncService.class.getName());

    public void processEventLog(EventLogClient eventLogClient, DocumentClient documentClient) throws RestAPIException {
        String topic = null;
        String id = null;
        String ref = null;
        ItemCollection snapshot = null;
        long count = 0L;
        long duration = System.currentTimeMillis();
        if (documentClient == null || eventLogClient == null) {
            logger.warning("...no eventLogClient available!");
            return;
        }
        eventLogClient.setPageSize(100);
        List events = eventLogClient.searchEventLog(new String[]{EVENTLOG_TOPIC_ADD, EVENTLOG_TOPIC_REMOVE});
        for (ItemCollection eventLogEntry : events) {
            topic = eventLogEntry.getItemValueString("topic");
            id = eventLogEntry.getItemValueString("id");
            ref = eventLogEntry.getItemValueString("ref");
            try {
                eventLogClient.lockEventLogEntry(id);
                if (topic.startsWith(EVENTLOG_TOPIC_ADD)) {
                    logger.finest("......pull snapshot " + ref + "....");
                    snapshot = this.pullSnapshot(eventLogEntry, documentClient, eventLogClient);
                }
                if (topic.startsWith(EVENTLOG_TOPIC_REMOVE)) {
                    logger.info("Remove Snapshot not yet implemented");
                }
                eventLogClient.deleteEventLogEntry(id);
                if (this.backupServiceEndpoint.isPresent() && !((String)this.backupServiceEndpoint.get()).isEmpty() && snapshot != null && !snapshot.hasItem(ITEM_BACKUPRESTORE)) {
                    logger.finest("......create event log entry snapshot.backup");
                    eventLogClient.createEventLogEntry(EVENTLOG_TOPIC_BACKUP, ref, null);
                    String mirrors = this.backupMirrors.orElse("");
                    if (!mirrors.isBlank()) {
                        List mirrorList = Arrays.stream(mirrors.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                        for (String mirrorID : mirrorList) {
                            eventLogClient.createEventLogEntry("snapshot.backup." + mirrorID, ref, null);
                        }
                    }
                }
                ++count;
            }
            catch (EJBException | ArchiveException | InvalidAccessException e) {
                logger.severe("SnapshotEvent " + id + " pull failed: " + e.getMessage());
                logger.warning("SnapshotEvent " + id + " will be removed!");
                eventLogClient.deleteEventLogEntry(id);
            }
        }
        if (count > 0L) {
            logger.info("Processed " + count + " snapshot events in " + (System.currentTimeMillis() - duration) + "ms");
        } else {
            logger.fine("Processed " + count + " snapshot events in " + (System.currentTimeMillis() - duration) + "ms");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseDeadLocks(EventLogClient eventLogClient) throws RestAPIException {
        if (eventLogClient == null) {
            logger.warning("...no eventLogClient available!");
            return;
        }
        eventLogClient.releaseDeadLocks(this.deadLockInterval, new String[]{EVENTLOG_TOPIC_ADD, EVENTLOG_TOPIC_REMOVE});
    }

    public ItemCollection pullSnapshot(ItemCollection eventLogEntry, DocumentClient documentClient, EventLogClient eventLogClient) throws ArchiveException {
        if (eventLogEntry == null || documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        String ref = eventLogEntry.getItemValueString("ref");
        String id = eventLogEntry.getItemValueString("id");
        logger.finest("...push " + ref + "...");
        long l = System.currentTimeMillis();
        try {
            ItemCollection snapshot = documentClient.getDocument(ref);
            if (snapshot != null) {
                logger.finest("...write snapshot...");
                this.dataService.saveSnapshot(snapshot);
                if (debug) {
                    logger.fine("...pulled " + ref + " in " + (System.currentTimeMillis() - l) + "ms");
                }
                return snapshot;
            }
        }
        catch (RestAPIException e) {
            logger.severe("Snapshot " + ref + " pull failed: " + e.getMessage());
            logger.warning("EventLogEntry " + id + " will be removed!");
            try {
                eventLogClient.deleteEventLogEntry(id);
            }
            catch (RestAPIException e1) {
                throw new ArchiveException("REMOTE_EXCEPTION", "Unable to delte eventLogEntry: " + id, (Exception)((Object)e1));
            }
        }
        return null;
    }
}

