/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.api;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.imixs.archive.service.api.XMLItemCollectionWriter;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;

@Provider
@Produces(value={"text/html"})
public class DocumentCollectionWriter
implements MessageBodyWriter<XMLDataCollection> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return XMLDataCollection.class.isAssignableFrom(type);
    }

    public void writeTo(XMLDataCollection entityCollection, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(entityStream));
        bw.write("<html>");
        XMLItemCollectionWriter.printHead((BufferedWriter)bw, (String)mediaType.toString(), null);
        bw.write("<body>");
        try {
            bw.write("<h1>EntityCollection</h1>");
            bw.write("<h2>" + entityCollection.getDocument().length + " Entries</h2>");
            for (XMLDocument xmlworkItem : entityCollection.getDocument()) {
                XMLItemCollectionWriter.printXMLItemCollectionHTML((BufferedWriter)bw, (XMLDocument)xmlworkItem);
            }
        }
        catch (Exception e) {
            bw.write("ERROR<br>");
        }
        bw.write("</body>");
        bw.write("</html>");
        bw.flush();
    }

    public long getSize(XMLDataCollection arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }
}

