/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class KeystoreService {
    public static final String ENV_SIGNATURE_KEYSTORE_PATH = "signature.keystore.path";
    public static final String ENV_SIGNATURE_KEYSTORE_PASSWORD = "signature.keystore.password";
    public static final String ENV_SIGNATURE_KEYSTORE_TYPE = "signature.keystore.type";
    @Inject
    @ConfigProperty(name="signature.keystore.path", defaultValue="/")
    String keyStorePath;
    @Inject
    @ConfigProperty(name="signature.keystore.password", defaultValue="/")
    String keyStorePassword;
    @Inject
    @ConfigProperty(name="signature.keystore.type", defaultValue=".jks")
    String keyStoreType;
    private static Logger logger = Logger.getLogger(KeystoreService.class.getName());

    public KeystoreService(String keyStorePath, String keyStorePassword, String keyStoreType) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
    }

    public KeystoreService() {
    }

    public KeyStore openKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        logger.finest("......open keystore");
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        File key = new File(this.keyStorePath);
        if (!key.exists()) {
            logger.warning("keystore " + this.keyStorePath + " does not exists - create empty keystore!");
            keyStore.load(null, this.keyStorePassword.toCharArray());
        } else {
            keyStore.load(new FileInputStream(key), this.keyStorePassword.toCharArray());
        }
        return keyStore;
    }

    public Certificate[] loadCertificate(String alias) {
        logger.finest("......load certificate '" + alias + "'");
        Certificate[] certificateChain = null;
        try {
            KeyStore keyStore = this.openKeyStore();
            String certAlias = alias;
            if (certAlias != null && !certAlias.isEmpty()) {
                certificateChain = keyStore.getCertificateChain(certAlias);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.warning("Failed to load certificate chain for alias '" + alias + "' - " + e.getMessage());
            certificateChain = null;
        }
        return certificateChain;
    }

    public PrivateKey loadPrivateKey(String alias, String password) {
        PrivateKey privateKey = null;
        logger.finest("......load PrivateKey '" + alias + "'");
        try {
            KeyStore keyStore = this.openKeyStore();
            if (password == null) {
                password = "";
            }
            privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            logger.warning("Failed to load PrivateKey '" + alias + "' from keystore - " + e.getMessage());
            privateKey = null;
        }
        return privateKey;
    }

    public PrivateKey loadPrivateKey(String alias) {
        return this.loadPrivateKey(alias, "");
    }

    public void storeCertificate(Certificate[] certificateChain, PrivateKey privKey, String password, String alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        logger.info("...store X509Certificate for alias '" + alias + "' into keystore...");
        KeyStore keyStore = this.openKeyStore();
        if (password == null || password.isEmpty()) {
            keyStore.setKeyEntry(alias, privKey, null, certificateChain);
        } else {
            keyStore.setKeyEntry(alias, privKey, password.toCharArray(), certificateChain);
        }
        FileOutputStream keyStoreOs = new FileOutputStream(this.keyStorePath);
        keyStore.store(keyStoreOs, this.keyStorePassword.toCharArray());
    }
}

