/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.workflow;

import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.signature.ca.CAService;
import org.imixs.archive.signature.ca.X509ProfileHandler;
import org.imixs.archive.signature.pdf.SigningService;
import org.imixs.archive.signature.pdf.cert.CertificateVerificationException;
import org.imixs.archive.signature.pdf.cert.SigningException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

public class SignatureAdapter
implements SignalAdapter {
    public static final String PDF_REGEX = "^.+\\.([pP][dD][fF])$";
    @Inject
    @ConfigProperty(name="signature.rootcert.alias")
    Optional<String> rootCertAlias;
    @Inject
    @ConfigProperty(name="signature.rootcert.password")
    Optional<String> rootCertPassword;
    @Inject
    SigningService signatureService;
    @Inject
    CAService caService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    WorkflowService workflowService;
    @Inject
    X509ProfileHandler x509ProfileHandler;
    private static Logger logger = Logger.getLogger(SignatureAdapter.class.getName());

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        boolean autocreate = true;
        boolean rootsignature = false;
        String file_pattern = PDF_REGEX;
        try {
            List fileNames = document.getFileNames();
            if (fileNames.size() > 0) {
                ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "signature", document, false);
                if (evalItemCollection != null) {
                    if (evalItemCollection.hasItem("autocreate")) {
                        autocreate = evalItemCollection.getItemValueBoolean("autocreate");
                    }
                    if (evalItemCollection.hasItem("rootsignature")) {
                        rootsignature = evalItemCollection.getItemValueBoolean("rootsignature");
                    }
                    if (evalItemCollection.hasItem("filepattern")) {
                        file_pattern = evalItemCollection.getItemValueString("filepattern");
                    }
                }
                Pattern filePatternMatcher = Pattern.compile(file_pattern);
                for (String fileName : fileNames) {
                    FileData fileData;
                    byte[] sourceContent;
                    if (!filePatternMatcher.matcher(fileName).find()) continue;
                    String certAlias = this.workflowService.getUserName();
                    logger.info("......signing " + fileName + " by '" + certAlias + "'...");
                    String certPassword = "";
                    if (!this.caService.existsCertificate(certAlias)) {
                        if (autocreate) {
                            ItemCollection x509Profile = this.x509ProfileHandler.findX509Profile(certAlias);
                            this.caService.createCertificate(certAlias, x509Profile);
                        } else if (rootsignature && this.rootCertAlias.isPresent()) {
                            certAlias = this.rootCertAlias.get();
                            if (this.rootCertPassword.isPresent()) {
                                certPassword = this.rootCertPassword.get();
                            }
                        } else {
                            throw new CertificateVerificationException("certificate for alias '" + certAlias + "' not found. Missing default certificate alias (SIGNATURE_KEYSTORE_DEFAULT_ALIAS)!");
                        }
                        if (!this.caService.existsCertificate(certAlias)) {
                            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "No certificate exists for user '" + certAlias + "'");
                        }
                    }
                    if ((sourceContent = (fileData = document.getFileData(fileName)).getContent()).length == 0) {
                        ItemCollection snapshot = this.snapshotService.findSnapshot(document);
                        fileData = snapshot.getFileData(fileName);
                        sourceContent = fileData.getContent();
                    }
                    File fileSignatureImage = new File("/opt/imixs-keystore/" + certAlias + ".jpg");
                    FileData signedFileData = this.signatureService.signPDF(fileData, certAlias, certPassword, fileSignatureImage);
                    document.addFileData(signedFileData);
                    logger.info("......signing " + fileName + " completed!");
                }
            }
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException | OperatorCreationException | CertificateVerificationException | SigningException | PluginException e) {
            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", e.getMessage(), (Exception)e);
        }
        return document;
    }
}

