/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.ca;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.signature.KeystoreService;
import org.imixs.archive.signature.ca.X509CertificateGenerator;
import org.imixs.workflow.ItemCollection;

@Singleton
public class CAService {
    @Inject
    @ConfigProperty(name="signature.rootcert.alias")
    Optional<String> rootCertAlias;
    @Inject
    @ConfigProperty(name="signature.rootcert.password")
    Optional<String> rootCertPassword;
    @Inject
    KeystoreService keystoreService;
    private static Logger logger = Logger.getLogger(CAService.class.getName());

    public boolean existsCertificate(String alias) {
        Certificate[] certificateChain = this.keystoreService.loadCertificate(alias);
        return certificateChain != null && certificateChain.length != 0;
    }

    public void createCertificate(String alias, ItemCollection profile) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, OperatorCreationException, CertificateException, SignatureException, IOException {
        Certificate[] certificateChain = null;
        logger.info("...generating new X509Certificate for alias '" + alias + "'...");
        X509CertificateGenerator x509CertificateGenerator = new X509CertificateGenerator();
        Certificate[] rootCertChain = this.keystoreService.loadCertificate(this.rootCertAlias.get());
        X509Certificate rootCert = (X509Certificate)rootCertChain[0];
        PrivateKey rootPrivKey = this.keystoreService.loadPrivateKey(this.rootCertAlias.get(), this.rootCertPassword.get());
        KeyPair issueKeyPair = x509CertificateGenerator.generateKeyPair();
        if (profile != null) {
            String cn = profile.getItemValueString("txtusername");
            if (cn.isEmpty()) {
                cn = alias;
            }
            certificateChain = x509CertificateGenerator.generateSignedCertificate(rootCert, rootPrivKey, issueKeyPair, cn, profile.getItemValueString("x509.o"), profile.getItemValue("x509.ou"), profile.getItemValueString("x509.city"), profile.getItemValueString("x509.state"), profile.getItemValueString("x509.country"));
        } else {
            certificateChain = x509CertificateGenerator.generateSignedCertificate(rootCert, rootPrivKey, issueKeyPair, alias, null, null, null, null, null);
        }
        this.keystoreService.storeCertificate(certificateChain, issueKeyPair.getPrivate(), "", alias);
    }
}

