/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.ca;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

@Named
@RequestScoped
public class X509ProfileHandler
implements Serializable {
    public static final String ENV_SIGNATURE_X509_PROFILE_QUERY = "signature.x509.profile.query";
    @EJB
    protected DocumentService documentService;
    @Inject
    @ConfigProperty(name="signature.x509.profile.query", defaultValue="(type:\"profile\") AND (name:\"?\" OR txtname:\"?\")")
    Optional<String> profileQuery;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(X509ProfileHandler.class.getName());

    public ItemCollection findX509Profile(String alias) {
        try {
            String query = this.profileQuery.get();
            query = query.replace("?", alias);
            List result = this.documentService.find(query, 1, 0);
            if (result.size() > 0) {
                return (ItemCollection)result.get(0);
            }
        }
        catch (QueryException e) {
            logger.severe("Invalid search query: " + this.profileQuery.get());
        }
        logger.warning("X509 Profile Data not found for alias '" + alias + "'");
        return null;
    }
}

