/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.signature.KeystoreService;
import org.imixs.archive.signature.pdf.Signature;
import org.imixs.archive.signature.pdf.cert.CertificateVerificationException;
import org.imixs.archive.signature.pdf.cert.SigningException;
import org.imixs.archive.signature.pdf.util.SigUtils;

@Stateless
@LocalBean
public class SigningService {
    public static final String ENV_SIGNATURE_TSA_URL = "signature.tsa.url";
    public static final String ENV_SIGNATURE_ROOTCERT_ALIAS = "signature.rootcert.alias";
    public static final String ENV_SIGNATURE_ROOTCERT_PASSWORD = "signature.rootcert.password";
    @Inject
    KeystoreService keystoreService;
    @Inject
    @ConfigProperty(name="signature.tsa.url")
    Optional<String> tsaURL;
    private static Logger logger = Logger.getLogger(SigningService.class.getName());

    public byte[] signPDF(byte[] inputFileData, String certAlias, String certPassword, boolean externalSigning) throws CertificateVerificationException, SigningException {
        byte[] signedFileData = this.signPDF(inputFileData, certAlias, certPassword, externalSigning, null, "Signature1", null, null);
        return signedFileData;
    }

    public byte[] signPDF(byte[] inputFileData, String certAlias, String certPassword, boolean externalSigning, Rectangle2D humanRect, String signatureFieldName, byte[] imageFile, String reason) throws CertificateVerificationException, SigningException {
        SignatureOptions signatureOptions = null;
        byte[] signedContent = null;
        if (inputFileData == null || inputFileData.length == 0) {
            throw new SigningException("empty file data");
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             PDDocument doc = PDDocument.load((byte[])inputFileData);){
            int accessPermissions = SigUtils.getMDPPermission(doc);
            if (accessPermissions == 1) {
                throw new SigningException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
            }
            PDSignature pdSignature = null;
            PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
            PDRectangle rect = null;
            if (acroForm != null) {
                try {
                    pdSignature = this.findExistingSignature(acroForm, signatureFieldName);
                    if (pdSignature != null) {
                        rect = ((PDAnnotationWidget)acroForm.getField(signatureFieldName).getWidgets().get(0)).getRectangle();
                    }
                }
                catch (IllegalStateException ise) {
                    logger.warning("signature " + signatureFieldName + " already exists: " + ise.getMessage());
                    signatureFieldName = signatureFieldName + ".1";
                }
            }
            if (pdSignature == null) {
                pdSignature = new PDSignature();
            }
            if (rect == null && humanRect != null) {
                rect = this.createSignatureRectangle(doc, humanRect);
            }
            if (doc.getVersion() >= 1.5f && accessPermissions == 0) {
                SigUtils.setMDPPermission(doc, pdSignature, 2);
            }
            if (acroForm != null && acroForm.getNeedAppearances()) {
                if (acroForm.getFields().isEmpty()) {
                    acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
                } else {
                    logger.warning("NeedAppearances is set, signature may be ignored by Adobe Reader");
                }
            }
            pdSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            pdSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            if (reason != null && !reason.isEmpty()) {
                pdSignature.setReason(reason);
            }
            pdSignature.setSignDate(Calendar.getInstance());
            Signature signature = null;
            Certificate[] certificateChain = null;
            certificateChain = this.keystoreService.loadCertificate(certAlias);
            if (certificateChain == null || certificateChain.length == 0) {
                throw new CertificateVerificationException("...certificate alias '" + certAlias + "' not found in keystore");
            }
            try {
                String sTsaUrl = null;
                if (this.tsaURL.isPresent() && !this.tsaURL.get().isEmpty()) {
                    sTsaUrl = this.tsaURL.get();
                }
                PrivateKey privateKey = this.keystoreService.loadPrivateKey(certAlias, certPassword);
                signature = new Signature(certificateChain, privateKey, sTsaUrl);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateExpiredException | CertificateNotYetValidException e) {
                throw new SigningException("Failed to create signature - " + e.getMessage(), e);
            }
            signatureOptions = new SignatureOptions();
            if (rect != null) {
                signatureOptions.setVisualSignature(this.createVisualSignatureTemplate(doc, 0, rect, pdSignature, imageFile, certificateChain));
            } else {
                logger.info("...Signature Image not provided, no VisualSignature will be added!");
            }
            signatureOptions.setPage(0);
            doc.addSignature(pdSignature, (SignatureInterface)signature, signatureOptions);
            if (externalSigning) {
                ExternalSigningSupport externalSigningSupport = doc.saveIncrementalForExternalSigning((OutputStream)bos);
                byte[] cmsSignature = signature.sign(externalSigningSupport.getContent());
                externalSigningSupport.setSignature(cmsSignature);
            } else {
                doc.saveIncremental((OutputStream)bos);
                signedContent = bos.toByteArray();
            }
        }
        catch (IOException e) {
            try {
                throw new SigningException("Failed to create signature - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(signatureOptions);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)signatureOptions);
        return signedContent;
    }

    private PDRectangle createSignatureRectangle(PDDocument doc, Rectangle2D humanRect) {
        float x = (float)humanRect.getX();
        float y = (float)humanRect.getY();
        float width = (float)humanRect.getWidth();
        float height = (float)humanRect.getHeight();
        PDPage page = doc.getPage(0);
        PDRectangle pageRect = page.getCropBox();
        PDRectangle rect = new PDRectangle();
        switch (page.getRotation()) {
            case 90: {
                rect.setLowerLeftY(x);
                rect.setUpperRightY(x + width);
                rect.setLowerLeftX(y);
                rect.setUpperRightX(y + height);
                break;
            }
            case 180: {
                rect.setUpperRightX(pageRect.getWidth() - x);
                rect.setLowerLeftX(pageRect.getWidth() - x - width);
                rect.setLowerLeftY(y);
                rect.setUpperRightY(y + height);
                break;
            }
            case 270: {
                rect.setLowerLeftY(pageRect.getHeight() - x - width);
                rect.setUpperRightY(pageRect.getHeight() - x);
                rect.setLowerLeftX(pageRect.getWidth() - y - height);
                rect.setUpperRightX(pageRect.getWidth() - y);
                break;
            }
            default: {
                rect.setLowerLeftX(x);
                rect.setUpperRightX(x + width);
                rect.setLowerLeftY(pageRect.getHeight() - y - height);
                rect.setUpperRightY(pageRect.getHeight() - y);
            }
        }
        return rect;
    }

    private InputStream createVisualSignatureTemplate(PDDocument srcDoc, int pageNum, PDRectangle rect, PDSignature signature, byte[] imageFile, Certificate[] certificateChain) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage(srcDoc.getPage(pageNum).getMediaBox());
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            widget.setRectangle(rect);
            PDStream stream = new PDStream(doc);
            PDFormXObject form = new PDFormXObject(stream);
            PDResources res = new PDResources();
            form.setResources(res);
            form.setFormType(1);
            PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
            float height = bbox.getHeight();
            Matrix initialScale = null;
            switch (srcDoc.getPage(pageNum).getRotation()) {
                case 90: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    break;
                }
                case 180: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                    break;
                }
                case 270: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    break;
                }
            }
            form.setBBox(bbox);
            PDType1Font font = PDType1Font.HELVETICA;
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            appearance.getCOSObject().setDirect(true);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
            appearance.setNormalAppearance(appearanceStream);
            widget.setAppearance(appearance);
            PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);
            Object object = null;
            try {
                if (initialScale != null) {
                    cs.transform(initialScale);
                }
                cs.addRect(-5000.0f, -5000.0f, 10000.0f, 10000.0f);
                float w = rect.getWidth();
                float h = rect.getHeight();
                cs.setStrokingColor(Color.BLACK);
                cs.moveTo(0.0f, h / 2.0f - 4.0f);
                cs.lineTo(w, h / 2.0f - 4.0f);
                cs.stroke();
                if (imageFile != null) {
                    cs.saveGraphicsState();
                    PDImageXObject img = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])imageFile, null);
                    float scaleFactor = rect.getHeight() / 2.0f / (float)img.getHeight();
                    cs.transform(Matrix.getScaleInstance((float)scaleFactor, (float)scaleFactor));
                    cs.drawImage(img, 2.0f, (float)img.getHeight());
                    cs.restoreGraphicsState();
                }
                float fontSize = 8.0f;
                float leading = fontSize * 1.5f;
                cs.beginText();
                cs.setFont((PDFont)font, fontSize);
                cs.setNonStrokingColor(Color.black);
                cs.newLineAtOffset(fontSize, height - leading - rect.getHeight() / 2.0f - 5.0f);
                cs.setLeading(leading);
                X509Certificate cert = (X509Certificate)certificateChain[0];
                X500Name x500Name = new X500Name(cert.getSubjectX500Principal().getName());
                RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
                String name = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd. MMM yyyy HH:mm:ss");
                String reason = signature.getReason();
                cs.showText("Signer: " + name);
                cs.newLine();
                cs.showText("Date: " + dateFormat.format(signature.getSignDate().getTime()));
                cs.newLine();
                cs.showText("Reason: " + reason);
                cs.endText();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (cs != null) {
                    if (object != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        cs.close();
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.save((OutputStream)baos);
            object = new ByteArrayInputStream(baos.toByteArray());
            return object;
        }
    }

    private PDSignature findExistingSignature(PDAcroForm acroForm, String sigFieldName) {
        PDSignatureField signatureField;
        PDSignature signature = null;
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
            } else {
                throw new IllegalStateException("The signature field " + sigFieldName + " is already signed.");
            }
        }
        return signature;
    }
}

