/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.workflow;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.signature.ca.CAService;
import org.imixs.archive.signature.ca.X509ProfileHandler;
import org.imixs.archive.signature.pdf.SigningService;
import org.imixs.archive.signature.pdf.cert.CertificateVerificationException;
import org.imixs.archive.signature.pdf.cert.SigningException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class SignatureAdapter
implements SignalAdapter {
    public static final String PDF_REGEX = "^.+\\.([pP][dD][fF])$";
    @Inject
    @ConfigProperty(name="signature.rootcert.alias")
    Optional<String> rootCertAlias;
    @Inject
    @ConfigProperty(name="signature.rootcert.password")
    Optional<String> rootCertPassword;
    @Inject
    SigningService signatureService;
    @Inject
    CAService caService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentService documentService;
    @Inject
    X509ProfileHandler x509ProfileHandler;
    private static Logger logger = Logger.getLogger(SignatureAdapter.class.getName());

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        boolean autocreate = true;
        boolean rootsignature = false;
        String file_pattern = PDF_REGEX;
        float positionx = 30.0f;
        float positiony = 700.0f;
        float dimensionw = 170.0f;
        float dimensionh = 100.0f;
        try {
            List fileNames = document.getFileNames();
            if (fileNames.size() > 0) {
                ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "signature", document, false);
                if (evalItemCollection != null) {
                    if (evalItemCollection.hasItem("autocreate")) {
                        autocreate = evalItemCollection.getItemValueBoolean("autocreate");
                    }
                    if (evalItemCollection.hasItem("rootsignature")) {
                        rootsignature = evalItemCollection.getItemValueBoolean("rootsignature");
                    }
                    if (evalItemCollection.hasItem("filepattern")) {
                        file_pattern = evalItemCollection.getItemValueString("filepattern");
                    }
                    if (evalItemCollection.hasItem("position-x")) {
                        positionx = evalItemCollection.getItemValueFloat("position-x");
                    }
                    if (evalItemCollection.hasItem("position-y")) {
                        positiony = evalItemCollection.getItemValueFloat("position-y");
                    }
                    if (evalItemCollection.hasItem("dimension-w")) {
                        dimensionw = evalItemCollection.getItemValueFloat("dimension-w");
                    }
                    if (evalItemCollection.hasItem("dimension-h")) {
                        dimensionh = evalItemCollection.getItemValueFloat("dimension-h");
                    }
                }
                Pattern filePatternMatcher = Pattern.compile(file_pattern);
                for (String fileName : fileNames) {
                    if (!filePatternMatcher.matcher(fileName).find()) continue;
                    String certPassword = "";
                    String certAlias = null;
                    if (rootsignature && this.rootCertAlias.isPresent()) {
                        certAlias = this.rootCertAlias.get();
                        if (this.rootCertPassword.isPresent()) {
                            certPassword = this.rootCertPassword.get();
                        }
                        if (!this.caService.existsCertificate(certAlias)) {
                            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "Root certificate '" + certAlias + "' does not exist!");
                        }
                        logger.info("......signing " + fileName + " with root certificate '" + certAlias + "'...");
                    } else {
                        certAlias = this.workflowService.getUserName();
                        logger.info("......signing " + fileName + " by '" + certAlias + "'...");
                        if (!this.caService.existsCertificate(certAlias)) {
                            if (!autocreate) {
                                throw new CertificateVerificationException("certificate for alias '" + certAlias + "' not found.");
                            }
                            ItemCollection x509Profile = this.x509ProfileHandler.findX509Profile(certAlias);
                            this.caService.createCertificate(certAlias, x509Profile);
                            if (!this.caService.existsCertificate(certAlias)) {
                                throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "No certificate exists for user '" + certAlias + "'");
                            }
                        }
                    }
                    FileData fileData = document.getFileData(fileName);
                    byte[] sourceContent = fileData.getContent();
                    if (sourceContent.length == 0) {
                        ItemCollection snapshot = this.snapshotService.findSnapshot(document);
                        fileData = snapshot.getFileData(fileName);
                        sourceContent = fileData.getContent();
                    }
                    byte[] signedContent = null;
                    if (rootsignature) {
                        signedContent = this.signatureService.signPDF(sourceContent, certAlias, certPassword, false);
                    } else {
                        int signatureCount;
                        byte[] signatureImage = null;
                        FileData fileDataSignature = this.loadSignatureImageFromProfile(certAlias);
                        if (fileDataSignature != null) {
                            signatureImage = fileDataSignature.getContent();
                        }
                        if ((signatureCount = document.getItemValueInteger("signature.count")) > 0) {
                            positionx += (float)signatureCount * dimensionw + 10.0f;
                        }
                        Rectangle2D.Float humanRect = new Rectangle2D.Float(positionx, positiony, dimensionw, dimensionh);
                        signedContent = this.signatureService.signPDF(sourceContent, certAlias, certPassword, false, humanRect, "Signature" + signatureCount, signatureImage, document.getItemValueString("$workflowstatus"));
                        document.setItemValue("signature.count", (Object)(signatureCount + 1));
                    }
                    FileData signedFileData = new FileData(fileName, signedContent, "application/pdf", null);
                    document.addFileData(signedFileData);
                    document.appendItemValue("$snapshot.overwriteFileContent", (Object)fileName);
                    logger.info("......signing " + fileName + " completed!");
                }
            }
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException | OperatorCreationException | CertificateVerificationException | SigningException | PluginException e) {
            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", e.getMessage(), (Exception)e);
        }
        return document;
    }

    private FileData loadSignatureImageFromProfile(String certAlias) {
        try {
            ItemCollection profile;
            FileData fileData;
            List userProfileList = this.documentService.find("type:profile AND txtname:" + certAlias, 1, 0);
            if (userProfileList.size() > 0 && (fileData = this.snapshotService.getWorkItemFile((profile = (ItemCollection)userProfileList.get(0)).getUniqueID(), "signature.jpg")) != null && fileData.getContent() != null && fileData.getContent().length > 0) {
                return fileData;
            }
        }
        catch (QueryException e) {
            logger.warning("Failed to load signature image from profile : " + e.getMessage());
        }
        return null;
    }
}

