/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.signature.workflow;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.bouncycastle.operator.OperatorCreationException;
import org.imixs.archive.signature.ca.CAService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

public class X509CertificateAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(X509CertificateAdapter.class.getName());
    @Inject
    CAService caService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        String certAlias = document.getItemValueString("txtname");
        logger.finest(".......adding new certificate for userid '" + certAlias + "'");
        try {
            this.caService.createCertificate(certAlias, document);
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException | OperatorCreationException e) {
            throw new ProcessingErrorException(this.getClass().getSimpleName(), "CERTIFICATE_ERROR", e.getMessage(), (Exception)e);
        }
        return document;
    }
}

