/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datagroup;

import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datagroup.DataGroupService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class DataGroupAdapter
implements SignalAdapter {
    public static final String MODE_ADD = "add";
    public static final String MODE_REMOVE = "remove";
    private static Logger logger = Logger.getLogger(DataGroupAdapter.class.getName());
    @Inject
    DocumentService documentService;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private DataGroupService dataGroupService;

    public DataGroupAdapter() {
    }

    @Inject
    public DataGroupAdapter(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        long processingTime = System.currentTimeMillis();
        List addDefinitions = this.workflowService.evalWorkflowResultXML(event, "imixs-data-group", MODE_ADD, workitem, true);
        List removeDefinitions = this.workflowService.evalWorkflowResultXML(event, "imixs-data-group", MODE_REMOVE, workitem, true);
        if (addDefinitions != null) {
            for (ItemCollection groupDefinition : addDefinitions) {
                this.addWorkitemToDataGroup(workitem, groupDefinition);
            }
        }
        if (removeDefinitions != null) {
            for (ItemCollection groupDefinition : removeDefinitions) {
                this.removeWorkitemFromDataGroup(workitem, groupDefinition);
            }
        }
        logger.info("\u251c\u2500\u2500 \u2705 completed (" + (System.currentTimeMillis() - processingTime) + "ms)");
        return workitem;
    }

    private void addWorkitemToDataGroup(ItemCollection workitem, ItemCollection groupDefinition) throws AccessDeniedException, PluginException {
        boolean debug = groupDefinition.getItemValueBoolean("debug");
        String query = groupDefinition.getItemValueString("query");
        query = this.workflowService.adaptText(query, workitem);
        String initModel = groupDefinition.getItemValueString("init.model");
        int initTaskId = groupDefinition.getItemValueInteger("init.task");
        int initEventId = groupDefinition.getItemValueInteger("init.event");
        String itemList = groupDefinition.getItemValueString("init.items");
        int updateEventId = groupDefinition.getItemValueInteger("update.event");
        logger.info("\u251c\u2500\u2500 add workitem to dataGroup: " + initModel);
        try {
            List refList;
            ItemCollection dataGroup = this.dataGroupService.findDataGroup(query);
            if (dataGroup == null) {
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 create new dataGroup " + initModel + " " + initTaskId + "." + initEventId);
                }
                dataGroup = this.dataGroupService.createDataGroup(initModel, initTaskId, initEventId, workitem, itemList);
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 dataGroup created");
                }
            }
            if (!(refList = workitem.getItemValue("$workitemref")).contains(dataGroup.getUniqueID())) {
                workitem.appendItemValueUnique("$workitemref", (Object)dataGroup.getUniqueID());
                if (updateEventId > 0) {
                    dataGroup.event(updateEventId);
                    this.workflowService.processWorkItem(dataGroup);
                }
            } else {
                logger.info("\u2502   \u251c\u2500\u2500 workitem already assigned to dataGroup '" + dataGroup.getUniqueID() + "'");
            }
        }
        catch (ModelException | ProcessingErrorException | QueryException e) {
            logger.warning("\u251c\u2500\u2500 \u26a0\ufe0f Failed to update dataGroup: " + e.getMessage());
            throw new PluginException(DataGroupAdapter.class.getName(), "API_ERROR", "\u26a0\ufe0f Failed to update dataGroup: " + e.getMessage(), (Exception)e);
        }
    }

    private void removeWorkitemFromDataGroup(ItemCollection workitem, ItemCollection groupDefinition) throws AccessDeniedException, PluginException {
        boolean debug = groupDefinition.getItemValueBoolean("debug");
        String query = groupDefinition.getItemValueString("query");
        query = this.workflowService.adaptText(query, workitem);
        int updateEventId = groupDefinition.getItemValueInteger("update.event");
        logger.info("\u251c\u2500\u2500 remove workitem '" + workitem.getUniqueID() + "' from dataGroup...");
        try {
            ItemCollection dataGroup = this.dataGroupService.findDataGroup(query);
            if (dataGroup != null) {
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 remove workitem '" + workitem.getUniqueID() + "' from dataGroup " + dataGroup.getUniqueID());
                }
                List refList = workitem.getItemValue("$workitemref");
                while (refList.contains(dataGroup.getUniqueID())) {
                    refList.remove(dataGroup.getUniqueID());
                    workitem.setItemValue("$workitemref", (Object)refList);
                }
                if (updateEventId > 0) {
                    dataGroup.event(updateEventId);
                    this.workflowService.processWorkItem(dataGroup);
                }
            } else {
                logger.info("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f no matching data group found");
            }
        }
        catch (ModelException | ProcessingErrorException | QueryException e) {
            logger.warning("\u251c\u2500\u2500 \u26a0\ufe0f Failed to update dataGroup: " + e.getMessage());
            throw new PluginException(DataGroupAdapter.class.getName(), "API_ERROR", "\u26a0\ufe0f Failed to update dataGroup: " + e.getMessage(), (Exception)e);
        }
    }
}

