/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datagroup;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@ConversationScoped
public class DataGroupController
extends ViewController {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SEARCH_RESULT = 1000;
    public static Logger logger = Logger.getLogger(DataGroupController.class.getName());
    @Inject
    protected WorkflowService workflowService;
    @Inject
    WorkflowController workflowController;
    @Inject
    private Conversation conversation;

    @PostConstruct
    public void init() {
        super.init();
        this.setSortBy("$modified");
        this.setSortReverse(false);
        this.setPageSize(100);
        this.setLoadStubs(false);
        this.startConversation();
    }

    protected void startConversation() {
        if (this.conversation.isTransient()) {
            this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
            this.conversation.begin();
            logger.log(Level.FINEST, "......start new conversation, id={0}", this.conversation.getId());
        }
    }

    public ItemCollection loadWorkitem(String id) {
        return this.workflowService.getWorkItem(id);
    }

    public String getQuery() {
        String uniqueId = this.workflowController.getWorkitem().getUniqueID();
        Object query = "(";
        query = " (type:\"workitem\" OR type:\"workitemarchive\") AND ($workitemref:\"" + uniqueId + "\")";
        logger.fine("Query= " + (String)query);
        return query;
    }

    public ItemCollection getWorkitem(String id) {
        return this.workflowService.getWorkItem(id);
    }

    public String getOptionValue(String options, String key) {
        String[] pairs;
        if (options == null || key == null || options.trim().isEmpty() || key.trim().isEmpty()) {
            return null;
        }
        for (String pair : pairs = options.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            String currentKey = keyValue[0].trim();
            String currentValue = keyValue[1].trim();
            if (!key.equals(currentKey)) continue;
            return currentValue;
        }
        return null;
    }
}

