/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datagroup;

import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datagroup.DataGroupAdapter;
import org.imixs.workflow.datagroup.DataGroupService;
import org.imixs.workflow.dataview.DataViewController;
import org.imixs.workflow.dataview.DataViewPOIHelper;
import org.imixs.workflow.dataview.DataViewService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

public class DataGroupExportAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DataGroupAdapter.class.getName());
    public static final String MODE_EXPORT = "export";
    @Inject
    DocumentService documentService;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private DataGroupService dataGroupService;
    @Inject
    private DataViewService dataViewService;

    public DataGroupExportAdapter() {
    }

    @Inject
    public DataGroupExportAdapter(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        long processingTime = System.currentTimeMillis();
        List exportDefinitions = this.workflowService.evalWorkflowResultXML(event, "imixs-data-group", MODE_EXPORT, workitem, true);
        if (exportDefinitions != null) {
            for (ItemCollection groupDefinition : exportDefinitions) {
                this.exportWorkitemToDataGroup(workitem, groupDefinition);
            }
        }
        logger.info("\u251c\u2500\u2500 \u2705 completed (" + (System.currentTimeMillis() - processingTime) + "ms)");
        return workitem;
    }

    private void exportWorkitemToDataGroup(ItemCollection workitem, ItemCollection groupDefinition) throws AccessDeniedException, PluginException {
        boolean debug = groupDefinition.getItemValueBoolean("debug");
        String type = groupDefinition.getItemValueString("type").trim();
        String separator = groupDefinition.getItemValueString("separator");
        if (separator.isBlank()) {
            separator = ";";
        }
        String targetname = groupDefinition.getItemValueString("targetname").trim();
        String dataview = groupDefinition.getItemValueString("dataview").trim();
        logger.info("\u251c\u2500\u2500 export dataGroup: " + type + " -> " + targetname);
        if (debug) {
            logger.info("\u2502   \u251c\u2500\u2500 type=" + type);
            logger.info("\u2502   \u251c\u2500\u2500 separator=" + separator);
            logger.info("\u2502   \u251c\u2500\u2500 dataview='" + dataview + "'");
        }
        try {
            ItemCollection dataViewDefinition = this.dataViewService.loadDataViewDefinition(dataview);
            if (dataViewDefinition == null) {
                throw new PluginException(DataGroupAdapter.class.getName(), "API_ERROR", "\u26a0\ufe0f Failed to dataview - not defined!");
            }
            byte[] fileRawData = null;
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 export data....");
            }
            if ("csv".equalsIgnoreCase(type)) {
                fileRawData = this.exportCSV(workitem, dataViewDefinition, separator);
                FileData fileData = new FileData(targetname, fileRawData, "application/text", null);
                workitem.addFileData(fileData);
                logger.info("\u2502   \u251c\u2500\u2500 \u2705 export successful");
            } else if ("poi".equalsIgnoreCase(type)) {
                FileData fileData = this.exportPoi(workitem, dataViewDefinition);
                workitem.addFileData(fileData);
                logger.info("\u2502   \u251c\u2500\u2500 \u2705 export successful");
            } else {
                logger.info("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f export type '" + type + "' not supported!");
            }
        }
        catch (QueryException e) {
            logger.warning("\u251c\u2500\u2500 \u26a0\ufe0f Failed to export dataGroup: " + e.getMessage());
            throw new PluginException(DataGroupAdapter.class.getName(), "API_ERROR", "\u26a0\ufe0f Failed to export dataGroup: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private byte[] exportCSV(ItemCollection workitem, ItemCollection dataViewDefinition, String separator) throws QueryException {
        List<ItemCollection> data;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));
        List viewItemDefinitions = this.dataViewService.computeDataViewItemDefinitions(dataViewDefinition);
        Object header = "";
        for (ItemCollection itemDef : viewItemDefinitions) {
            String label = itemDef.getItemValueString("item.label");
            header = (String)header + this.escapeCSVField(label) + separator;
        }
        if (((String)header).length() > 0) {
            header = ((String)header).substring(0, ((String)header).length() - separator.length());
        }
        writer.println((String)header);
        int page = 0;
        while ((data = this.dataGroupService.loadData(workitem.getUniqueID(), 500, page, null, false, false)).size() != 0) {
            logger.info("\u2502   \u251c\u2500\u2500 \u2611\ufe0f loaded data - " + data.size() + " workitems found");
            for (ItemCollection dataWorkitem : data) {
                Object line = "";
                for (ItemCollection itemDef : viewItemDefinitions) {
                    String type = itemDef.getItemValueString("item.type");
                    String name = itemDef.getItemValueString("item.name");
                    String format = itemDef.getItemValueString("item.format");
                    String fieldValue = "";
                    switch (type) {
                        case "xs:double": {
                            double _double = dataWorkitem.getItemValueDouble(name);
                            if (format != null && !format.isEmpty()) {
                                fieldValue = String.format(format, _double);
                                break;
                            }
                            fieldValue = String.valueOf(_double);
                            break;
                        }
                        case "xs:float": {
                            float _float = dataWorkitem.getItemValueFloat(name);
                            if (format != null && !format.isEmpty()) {
                                fieldValue = String.format(format, Float.valueOf(_float));
                                break;
                            }
                            fieldValue = String.valueOf(_float);
                            break;
                        }
                        case "xs:int": {
                            int _int = dataWorkitem.getItemValueInteger(name);
                            if (format != null && !format.isEmpty()) {
                                fieldValue = String.format(format, _int);
                                break;
                            }
                            fieldValue = String.valueOf(_int);
                            break;
                        }
                        case "xs:date": {
                            Date _date = dataWorkitem.getItemValueDate(name);
                            if (_date == null) break;
                            if (format != null && !format.isEmpty()) {
                                SimpleDateFormat sdf = new SimpleDateFormat(format);
                                fieldValue = sdf.format(_date);
                                break;
                            }
                            fieldValue = _date.toString();
                            break;
                        }
                        default: {
                            String value = dataWorkitem.getItemValueString(name);
                            if (value == null) break;
                            fieldValue = format != null && !format.isEmpty() ? String.format(format, value) : value;
                        }
                    }
                    line = (String)line + this.escapeCSVField(fieldValue) + separator;
                }
                if (((String)line).length() > 0) {
                    line = ((String)line).substring(0, ((String)line).length() - separator.length());
                }
                writer.println((String)line);
            }
            ++page;
        }
        writer.flush();
        writer.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String escapeCSVField(String field) {
        if (field == null) {
            return "";
        }
        if (field.contains(",") || field.contains(";") || field.contains("\n") || field.contains("\r") || field.contains("\"")) {
            return "\"" + field.replace("\"", "\"\"") + "\"";
        }
        return field;
    }

    private FileData exportPoi(ItemCollection workitem, ItemCollection dataViewDefinition) throws QueryException, PluginException {
        List<ItemCollection> workitems;
        String uniqueid = workitem.getUniqueID();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));
        List viewItemDefinitions = this.dataViewService.computeDataViewItemDefinitions(dataViewDefinition);
        FileData templateFileData = this.dataViewService.loadTemplate(dataViewDefinition);
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
        Object targetFileName = dataViewDefinition.getItemValueString("poi.targetFilename");
        if (((String)targetFileName).isEmpty()) {
            throw new PluginException(DataViewController.class.getSimpleName(), "CONFIG_ERROR", "Missing Excel Export definition - check configuration!");
        }
        targetFileName = (String)targetFileName + "_" + dateformat.format(new Date()) + ".xlsx";
        String sortBy = dataViewDefinition.getItemValueString("sort.by");
        if (sortBy.isEmpty()) {
            sortBy = "$modified";
        }
        if ((workitems = this.dataGroupService.loadData(uniqueid, 9999, 0, sortBy, false, false)).size() > 0) {
            this.dataViewService.poiExport(workitems, dataViewDefinition, viewItemDefinitions, templateFileData);
        }
        ItemCollection event = new ItemCollection().setItemValue("txtActivityResult", (Object)dataViewDefinition.getItemValue("poi.update"));
        ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", dataViewDefinition, false);
        DataViewPOIHelper.poiUpdate((ItemCollection)workitem, (FileData)templateFileData, (ItemCollection)poiConfig, (WorkflowService)this.workflowService);
        templateFileData.setName((String)targetFileName);
        return templateFileData;
    }
}

