/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datagroup;

import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

@Stateless
@LocalBean
public class DataGroupService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DataGroupService.class.getName());
    public static final String ITEM_WORKITEMREF = "$workitemref";
    public static final String API_ERROR = "API_ERROR";
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    @Inject
    protected WorkflowService workflowService;
    @Inject
    protected DocumentService documentService;

    public ItemCollection findDataGroup(String query) throws QueryException {
        List resultList = this.workflowService.getDocumentService().find(query, 1, 0, "$modified", true);
        if (resultList.size() > 0) {
            return (ItemCollection)resultList.get(0);
        }
        return null;
    }

    public ItemCollection createDataGroup(String modelVersion, int taskId, int eventId, ItemCollection source, String items) throws ModelException, PluginException {
        logger.info("Create new DataGroup " + modelVersion + " " + taskId + "." + eventId);
        ItemCollection dataGroup = new ItemCollection().model(modelVersion).task(taskId).event(eventId);
        this.copyItemList(items, source, dataGroup);
        return this.workflowService.processWorkItem(dataGroup);
    }

    protected void copyItemList(String items, ItemCollection source, ItemCollection target) {
        logger.info("copy itemlist: " + items);
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (field.startsWith("(") && field.endsWith(")")) {
                Pattern itemPattern = Pattern.compile(field);
                Map map = source.getAllItems();
                for (String itemName : map.keySet()) {
                    if (!itemPattern.matcher(itemName).find()) continue;
                    target.replaceItemValue(itemName, (Object)source.getItemValue(itemName));
                }
                continue;
            }
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }

    public List<ItemCollection> loadData(String uniqueId, int pageSize, int pageIndex, String sortBy, boolean sortReverse, boolean loadStubs) throws QueryException {
        Object query = "(";
        query = " (type:\"workitem\" OR type:\"workitemarchive\") AND ($workitemref:\"" + uniqueId + "\")";
        logger.fine("Query= " + (String)query);
        List result = null;
        result = loadStubs ? this.documentService.findStubs((String)query, pageSize, pageIndex, sortBy, sortReverse) : this.documentService.find((String)query, pageSize, pageIndex, sortBy, sortReverse);
        return result;
    }
}

