/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.importer.ftp;

import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.importer.DocumentImportEvent;
import org.imixs.workflow.importer.DocumentImportService;

@Stateless
public class FTPImportService {
    private static Logger logger = Logger.getLogger(FTPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@Observes DocumentImportEvent event) {
        block37: {
            if (event.getResult() == 1) {
                logger.finest("...... import source already completed - no processing will be performed.");
                return;
            }
            if (!"FTP".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
                logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
                return;
            }
            String ftpServer = event.getSource().getItemValueString("server");
            String ftpPort = event.getSource().getItemValueString("port");
            String ftpUser = event.getSource().getItemValueString("user");
            String ftpPassword = event.getSource().getItemValueString("password");
            Object ftpPath = event.getSource().getItemValueString("selector");
            if (!((String)ftpPath).startsWith("/") && !((String)ftpPath).startsWith("./")) {
                ftpPath = "/" + (String)ftpPath;
            }
            if (!((String)ftpPath).endsWith("/")) {
                ftpPath = (String)ftpPath + "/";
            }
            if (ftpServer.isEmpty()) {
                logger.warning("...... no server specified!");
                return;
            }
            if (ftpPort.isEmpty()) {
                ftpPort = "21";
            }
            FTPSClient ftpClient = null;
            try {
                logger.finest("......read directories ...");
                this.documentImportService.logMessage("\u251c\u2500\u2500 \ud83d\uddc4\ufe0f connecting to FTP server: " + ftpServer, event);
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding("UTF-8");
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f FTP file transfer failed: login failed!", event);
                    event.setResult(2);
                    return;
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=2");
                ftpClient.setFileType(2);
                ftpClient.setControlEncoding("UTF-8");
                boolean bWorkingDir = ftpClient.changeWorkingDirectory((String)ftpPath);
                if (bWorkingDir) {
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 working directory: " + ftpClient.printWorkingDirectory(), event);
                    FTPFile[] allFiles = ftpClient.listFiles();
                    int count = 0;
                    if (allFiles.length > 0) {
                        this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 " + allFiles.length + " files found ", event);
                        for (FTPFile file : allFiles) {
                            if (!file.isFile()) {
                                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f '" + file.getName() + "' is not a valid file, object will be ignored!", event);
                                continue;
                            }
                            logger.info("import file " + file.getName() + "...");
                            try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                                ftpClient.retrieveFile(file.getName(), (OutputStream)is);
                                byte[] rawData = is.toByteArray();
                                if (rawData != null && rawData.length > 0) {
                                    logger.finest("......file '" + file.getName() + "' successful read - bytes size = " + rawData.length);
                                    this.createWorkitem(event.getSource(), file.getName(), rawData);
                                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u2611\ufe0f imported '" + file.getName() + "'", event);
                                    ++count;
                                } else {
                                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f invalid file content '" + file.getName() + "' - file will be deleted!", event);
                                }
                                ftpClient.deleteFile(file.getName());
                            }
                            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
                                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f FTP import failed: " + e.getMessage(), event);
                                event.setResult(2);
                                try {
                                    ftpClient.logout();
                                    ftpClient.disconnect();
                                }
                                catch (IOException e2) {
                                    this.documentImportService.logMessage("\u2514\u2500\u2500 \u26a0\ufe0f FTP file transfer failed: " + e2.getMessage(), event);
                                    event.setResult(2);
                                    return;
                                }
                                return;
                            }
                        }
                        this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Completed - " + count + " new files imported.", event);
                        break block37;
                    }
                    this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Completed - no files found, directory '" + (String)ftpPath + "' is empty", event);
                    break block37;
                }
                this.documentImportService.logMessage("\u2514\u2500\u2500 \u26a0\ufe0f failed to change into working directory: " + (String)ftpPath, event);
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                this.documentImportService.logMessage("...FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            finally {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    this.documentImportService.logMessage("\u2514\u2500\u2500 \u26a0\ufe0f FTP file transfer failed: " + e.getMessage(), event);
                    event.setResult(2);
                    return;
                }
            }
        }
        event.setResult(1);
    }

    public ItemCollection createWorkitem(ItemCollection source, String fileName, byte[] rawData) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        workitem.setItemValue("document.import.type", (Object)source.getItemValue("type"));
        workitem.setItemValue("document.import.selector", (Object)source.getItemValue("selector"));
        workitem.setItemValue("document.import.options", (Object)source.getItemValue("options"));
        String contentType = "*/*";
        if (fileName.toLowerCase().endsWith(".pdf")) {
            contentType = "Application/PDF";
        }
        FileData fileData = new FileData(fileName, rawData, contentType, null);
        workitem.addFileData(fileData);
        workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
        return workitem;
    }
}

