/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.importer.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class IMAPImportHelper {
    private static Logger logger = Logger.getLogger(IMAPImportHelper.class.getName());

    public static boolean isMediaTypeOctet(String contentType, String filename) {
        if (contentType.contains("application/octet-stream")) {
            return true;
        }
        if (contentType.toLowerCase().startsWith("application/octet")) {
            logger.warning("Unknow ContentType: " + contentType + " - in " + filename);
            return true;
        }
        return false;
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    public static String fixContentType(String contentType, String fileName, boolean debug) {
        if (contentType == null || contentType.isEmpty()) {
            return contentType;
        }
        String fixedContentType = contentType.replaceAll("[\\s.]*(/)[\\s.]*", "$1");
        if (!contentType.equals(fixedContentType)) {
            logger.info("...fixed content type: '" + contentType + "' -> '" + fixedContentType + "'");
            contentType = fixedContentType;
        }
        if (IMAPImportHelper.isMediaTypeOctet(contentType, fileName) && fileName.toLowerCase().endsWith(".pdf")) {
            logger.info("...converting mimetype '" + contentType + "' to application/pdf");
            contentType = "application/pdf";
        }
        if (contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(";"));
        }
        if (debug) {
            logger.info("mimetype=" + contentType);
        }
        return contentType;
    }
}

