/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.importer.ftp;

import jakarta.ejb.EJBException;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.importer.DocumentImportEvent;
import org.imixs.workflow.importer.DocumentImportService;

@Named
public class CSVImportService {
    public static final String DATA_ERROR = "DATA_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    public static final String IMPORT_ERROR = "IMPORT_ERROR";
    private static Logger logger = Logger.getLogger(CSVImportService.class.getName());
    @Inject
    UpdateService indexUpdateService;
    @Inject
    DocumentService documentService;
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentImportService documentImportService;

    public void onEvent(@Observes DocumentImportEvent event) {
        if (event.getResult() == 1) {
            logger.finest("...... import source already completed - no processing will be performed.");
            return;
        }
        if (!"CSV".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
            logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skipped.");
            return;
        }
        try {
            String encoding;
            Object keyField;
            String ftpServer = event.getSource().getItemValueString("server");
            Object csvSelector = event.getSource().getItemValueString("selector");
            if (!((String)csvSelector).startsWith("/") && !((String)csvSelector).startsWith("./")) {
                csvSelector = "/" + (String)csvSelector;
            }
            if (csvSelector == null || ((String)csvSelector).isEmpty() || !((String)csvSelector).toLowerCase().endsWith(".csv")) {
                this.documentImportService.logMessage("...invalid selector - .csv file path missing - " + (String)csvSelector, event);
            }
            this.documentImportService.logMessage("\u251c\u2500\u2500 csv import: " + (String)csvSelector, event);
            Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
            String type = sourceOptions.getProperty("type");
            if (type == null || type.isEmpty()) {
                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 Missing property 'type' - set default 'workitem'", event);
                type = "workitem";
            }
            if ("workitem".equals(type)) {
                String modelVersion = event.getSource().getItemValueString("workflowmodel");
                String workflowGroup = event.getSource().getItemValueString("workflowgroup");
                int taskID = event.getSource().getItemValueInteger("task");
                int eventID = event.getSource().getItemValueInteger("event");
                if (modelVersion.isBlank() && workflowGroup.isBlank()) {
                    String error = "either $workflowgroup or $modelversion must be set! ";
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Missing configuration: " + error, event);
                    throw new PluginException(this.getClass().getName(), CONFIG_ERROR, error);
                }
                if (taskID == 0 || eventID == 0) {
                    String error = "$taskID and $eventID must be set! ";
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Missing configuration: " + error, event);
                    throw new PluginException(this.getClass().getName(), CONFIG_ERROR, error);
                }
            }
            if ((keyField = sourceOptions.getProperty("key")) == null || ((String)keyField).isEmpty()) {
                throw new PluginException(this.getClass().getName(), CONFIG_ERROR, "Missing property 'key' to import entities");
            }
            if (!((String)keyField).startsWith("_")) {
                keyField = "_" + (String)keyField;
            }
            if ((encoding = sourceOptions.getProperty("encoding")) == null || encoding.isEmpty()) {
                encoding = "UTF-8";
            }
            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 encoding=" + encoding, event);
            FileData fileData = null;
            if (!ftpServer.isEmpty()) {
                fileData = this.readFileDataFromFTP(ftpServer, (String)csvSelector, encoding, event);
            } else {
                Path path = Paths.get((String)csvSelector, new String[0]);
                String fileName = path.getFileName().toString();
                byte[] fileContent = Files.readAllBytes(Paths.get((String)csvSelector, new String[0]));
                fileData = new FileData(fileName, fileContent, null, null);
            }
            if (fileData != null) {
                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u2699\ufe0f file '" + fileData.getName() + "' processing \u25b7 " + fileData.getContent().length + " bytes", event);
                String lastChecksum = event.getSource().getItemValueString("csv.checksum");
                String newChecksum = fileData.generateMD5();
                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 checksum=" + newChecksum, event);
                if (lastChecksum.isEmpty() || !lastChecksum.equals(newChecksum)) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getContent());
                    String log = this.importData(inputStream, encoding, type, (String)keyField, event);
                    event.getSource().setItemValue("csv.checksum", (Object)newChecksum);
                    this.documentImportService.logMessage(log, event);
                    this.documentImportService.logMessage("\u251c\u2500\u2500 \u2705 file import completed successful.", event);
                } else {
                    this.documentImportService.logMessage("\u251c\u2500\u2500 \u2705 no data changes since last import.", event);
                }
            } else {
                this.documentImportService.logMessage("...Warning - invalid file content '" + fileData.getName() + "' - file will be deleted!", event);
            }
        }
        catch (IOException | NoSuchAlgorithmException | PluginException e) {
            logger.severe("Data Error: " + e.getMessage());
            e.printStackTrace();
            this.documentImportService.logMessage("\u251c\u2500\u2500 \u26a0\ufe0f file import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
        this.indexUpdateService.updateIndex();
        event.setResult(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileData readFileDataFromFTP(String ftpServer, String csvSelector, String encoding, DocumentImportEvent event) {
        FileData fileData;
        block36: {
            FTPSClient ftpClient = null;
            fileData = null;
            try {
                String ftpPort = event.getSource().getItemValueString("port");
                String ftpUser = event.getSource().getItemValueString("user");
                String ftpPassword = event.getSource().getItemValueString("password");
                if (ftpServer.isEmpty()) {
                    logger.warning("...... no server specified!");
                    FileData fileData2 = null;
                    return fileData2;
                }
                if (ftpPort.isEmpty()) {
                    ftpPort = "21";
                }
                logger.finest("......read directories ...");
                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 connecting to FTP server: " + ftpServer, event);
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding(encoding);
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    this.documentImportService.logMessage("FTP file transfer failed: login failed!", event);
                    event.setResult(2);
                    FileData fileData3 = null;
                    return fileData3;
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=2");
                ftpClient.setFileType(2);
                ftpClient.setControlEncoding(encoding);
                File file = new File(csvSelector);
                String csvFTPPath = file.getParent();
                String csvFilename = file.getName();
                boolean bWorkingDir = ftpClient.changeWorkingDirectory(csvFTPPath);
                if (bWorkingDir) {
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 working directory: " + ftpClient.printWorkingDirectory(), event);
                    logger.info("import file " + csvFilename + "...");
                    try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                        ftpClient.retrieveFile(csvFilename, (OutputStream)is);
                        byte[] rawData = is.toByteArray();
                        try {
                            logger.info("...document content read, closing FTP client.");
                            ftpClient.logout();
                            ftpClient.disconnect();
                        }
                        catch (IOException e) {
                            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 FTP error - failed to close connection after reading CSV File: " + e.getMessage(), event);
                        }
                        fileData = new FileData(file.getName(), rawData, null, null);
                        break block36;
                    }
                    catch (AccessDeniedException | ProcessingErrorException e) {
                        this.documentImportService.logMessage("...FTP import failed: " + e.getMessage(), event);
                        event.setResult(2);
                        FileData fileData4 = null;
                        try {
                            if (ftpClient.isConnected()) {
                                logger.warning("FTP Client is till connected, closing.....");
                                ftpClient.logout();
                                ftpClient.disconnect();
                            }
                        }
                        catch (IOException e2) {
                            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 FTP file transfer failed: " + e2.getMessage(), event);
                            event.setResult(2);
                            return null;
                        }
                        return fileData4;
                    }
                }
                this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 failed to change into working directory: " + csvFTPPath, event);
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                if (ftpClient.isConnected()) {
                    int r = ftpClient.getReplyCode();
                    logger.severe("FTP ReplyCode=" + r);
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), event);
                }
                event.setResult(2);
                FileData fileData5 = null;
                return fileData5;
            }
            finally {
                try {
                    if (ftpClient.isConnected()) {
                        logger.warning("FTP Client is till connected, closing.....");
                        ftpClient.logout();
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e) {
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 FTP file transfer failed: " + e.getMessage(), event);
                    event.setResult(2);
                    return null;
                }
            }
        }
        return fileData;
    }

    public String importData(InputStream inputStream, String encoding, String type, String keyField, DocumentImportEvent event) throws PluginException {
        logger.fine("...starting csv data import...");
        Object log = "";
        int line = 0;
        String dataLine = null;
        ArrayList<String> csvIndexCache = new ArrayList<String>();
        Map<String, RecordComparator> databaseCache = null;
        int workitemsTotal = 0;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsDeleted = 0;
        int workitemsFailed = 0;
        int blockSize = 0;
        String modelVersion = event.getSource().getItemValueString("workflowmodel");
        String workflowGroup = event.getSource().getItemValueString("workflowgroup");
        int taskID = event.getSource().getItemValueInteger("task");
        int eventID = event.getSource().getItemValueInteger("event");
        String csvFileName = event.getSource().getItemValueString("selector");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding));
            String header = in.readLine();
            if (!header.contains(";")) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, fields must be separated by ';' ");
            }
            List<String> fields = this.parseFieldList(header);
            if (fields == null || fields.size() == 0) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the item names.");
            }
            if (type == null || type.isEmpty()) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "Missing type to import entities");
            }
            databaseCache = this.readDocumentsFromDatabase(fields, type, event);
            logger.info("...object type=" + type);
            logger.info("...key field=" + keyField);
            ++line;
            while ((dataLine = in.readLine()) != null) {
                ++blockSize;
                ++line;
                ++workitemsTotal;
                ItemCollection entity = this.readEntity(dataLine, fields, type, keyField);
                if (entity == null) {
                    logger.warning("...Incorrect data line: " + dataLine);
                    continue;
                }
                String keyItemValue = entity.getItemValueString("name");
                if (keyItemValue.isBlank()) {
                    logger.warning("KeyField '" + keyField + "' is empty - line:" + line);
                    continue;
                }
                if (csvIndexCache.contains(keyItemValue)) {
                    logger.warning("...WARNING duplicate entry found: " + keyField + "=" + keyItemValue);
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f duplicate entry found: " + keyField + "=" + keyItemValue, event);
                    continue;
                }
                csvIndexCache.add(keyItemValue);
                entity.setItemValue("document.import.type", (Object)event.getSource().getItemValue("type"));
                entity.setItemValue("document.import.selector", (Object)event.getSource().getItemValue("selector"));
                entity.setItemValue("document.import.options", (Object)event.getSource().getItemValue("options"));
                RecordComparator record = new RecordComparator(entity, fields);
                RecordComparator existingIndex = databaseCache.get(record.id);
                if (existingIndex != null && existingIndex.hash == record.hash) continue;
                if (existingIndex == null) {
                    entity.task(taskID);
                    this.processEntity(entity, modelVersion, workflowGroup, eventID);
                    ++workitemsImported;
                } else {
                    logger.fine("update existing entity");
                    ItemCollection existingEntity = this.documentService.load(existingIndex.uniqueId);
                    existingEntity.replaceAllItems(entity.getAllItems());
                    this.processEntity(existingEntity, modelVersion, workflowGroup, eventID);
                    ++workitemsUpdated;
                }
                if (blockSize < 100) continue;
                blockSize = 0;
                logger.info("\u2502   \u251c\u2500\u2500 " + csvFileName + ": " + workitemsTotal + " entries read (" + workitemsImported + " imports , " + workitemsUpdated + " updates)");
                this.indexUpdateService.updateIndex();
            }
            logger.info("completed: " + workitemsTotal + " entries successful read");
        }
        catch (Exception e) {
            ++workitemsFailed;
            String sError = "import error at line " + line + ": " + String.valueOf(e) + " data=" + dataLine;
            logger.severe(sError);
            throw new PluginException(CSVImportService.class.getName(), DATA_ERROR, sError, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Set<String> databaseKeys = databaseCache.keySet();
        for (String key : databaseKeys) {
            if (csvIndexCache.contains(key)) continue;
            ItemCollection deprecatedEntity = this.documentService.load(databaseCache.get((Object)key).uniqueId);
            this.documentService.remove(deprecatedEntity);
            ++workitemsDeleted;
        }
        log = (String)log + "..." + workitemsTotal + " entries read -> " + workitemsImported + " new entries - " + workitemsUpdated + " updates - " + workitemsDeleted + " deletions - " + workitemsFailed + " errors";
        logger.info((String)log);
        return log;
    }

    private void processEntity(ItemCollection entity, String modelVersion, String workflowGroup, int eventID) {
        if (eventID > 0) {
            entity.model(modelVersion).workflowGroup(workflowGroup).event(eventID);
            try {
                this.workflowService.processWorkItemByNewTransaction(entity);
            }
            catch (EJBException | AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
                logger.warning("Processing failed: " + e.getMessage());
                this.documentService.saveByNewTransaction(entity);
            }
        } else {
            this.documentService.saveByNewTransaction(entity);
        }
    }

    private Map<String, RecordComparator> readDocumentsFromDatabase(List<String> fields, String type, DocumentImportEvent event) throws QueryException, PluginException {
        int pageIndex = 0;
        int pageSize = 100;
        int totalCount = 0;
        HashMap<String, RecordComparator> result = new HashMap<String, RecordComparator>();
        String modelVersion = event.getSource().getItemValueString("workflowmodel");
        String workflowGroup = event.getSource().getItemValueString("workflowgroup");
        logger.info("\u2502   \u251c\u2500\u2500 read entries from database...");
        String query = "(type:" + type + ") ";
        if ("workitem".equalsIgnoreCase(type) && modelVersion.isEmpty() && workflowGroup.isEmpty()) {
            throw new PluginException(this.getClass().getName(), DATA_ERROR, "Missing definition of $workflowgroup/$modelversion - type=='workitem' ! ");
        }
        if (!workflowGroup.isEmpty()) {
            query = query + " AND ($workflowgroup:\"" + workflowGroup + "\") ";
        } else if (!modelVersion.isEmpty()) {
            query = query + " AND ($modelversion:\"" + modelVersion + "\") ";
        }
        logger.info("\u2502   \u251c\u2500\u2500 query=" + query);
        while (true) {
            List entries = this.documentService.find(query, pageSize, pageIndex, "$created", false);
            for (ItemCollection entity : entries) {
                ++totalCount;
                String id = entity.getItemValueString("name");
                result.put(id, new RecordComparator(entity, fields));
            }
            if (entries.size() != pageSize) break;
            ++pageIndex;
            logger.info("\u2502   \u251c\u2500\u2500 " + totalCount + " entries read");
        }
        return result;
    }

    private ItemCollection readEntity(String data, List<String> fieldnames, String type, String keyField) {
        ItemCollection result = new ItemCollection();
        result.replaceItemValue("type", (Object)type);
        int iCol = 0;
        String[] valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
        for (String itemValue : valuList = this.normalizeValueList(valuList)) {
            if ((itemValue = itemValue.trim()) != null && !itemValue.isEmpty()) {
                result.replaceItemValue(fieldnames.get(iCol), (Object)itemValue);
            } else {
                result.replaceItemValue(fieldnames.get(iCol), (Object)"");
            }
            if (++iCol >= fieldnames.size()) break;
        }
        String keyItemValue = result.getItemValueString(keyField);
        result.replaceItemValue("name", (Object)keyItemValue);
        return result;
    }

    private String[] normalizeValueList(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String value = data[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            data[i] = value = value.substring(1, value.length() - 1);
        }
        return data;
    }

    private List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (!field.isEmpty()) {
                field = field.replace("\"", "");
                field = field.replace("'", "");
                field = field.replace(".", "");
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add("_" + field.trim());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    class RecordComparator {
        String id;
        int hash;
        String uniqueId;

        public RecordComparator(ItemCollection entity, List<String> fields) {
            this.id = entity.getItemValueString("name");
            this.hash = this.generateHash(entity, fields);
            this.uniqueId = entity.getUniqueID();
        }

        private int generateHash(ItemCollection wokritem, List<String> fields) {
            Object result = "";
            for (String item : fields) {
                result = (String)result + wokritem.getItemValueString(item);
            }
            return ((String)result).hashCode();
        }
    }
}

