/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.importer.ftp;

import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.importer.DocumentImportEvent;
import org.imixs.workflow.importer.DocumentImportService;

@Stateless
public class FTPImportService {
    private static final Logger logger = Logger.getLogger(FTPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;

    public void onEvent(@Observes DocumentImportEvent event) {
        if (event.getResult() == 1) {
            logger.finest("...... import source already completed - no processing will be performed.");
            return;
        }
        String type = event.getSource().getItemValueString("type");
        if (!List.of("FTP", "FTPS", "SFTP").contains(type.toUpperCase())) {
            logger.finest("...... type '" + type + "' skipped.");
            return;
        }
        String server = event.getSource().getItemValueString("server");
        String port = event.getSource().getItemValueString("port");
        String user = event.getSource().getItemValueString("user");
        String password = event.getSource().getItemValueString("password");
        String path = event.getSource().getItemValueString("selector");
        Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
        boolean insecureSSH = Boolean.parseBoolean(sourceOptions.getProperty("ftp.insecure", "false"));
        String ftpSubProtocol = sourceOptions.getProperty("ftp.subprotocol", "FTP");
        this.documentImportService.logMessage("\u251c\u2500\u2500 \ud83d\uddc4\ufe0f FTP Import: server: " + ftpSubProtocol + "://" + server, event);
        if (server == null || server.isEmpty()) {
            this.documentImportService.logMessage("\u251c\u2500\u2500 \u26a0\ufe0f No server specified!", event);
            return;
        }
        if (port == null || port.isEmpty()) {
            port = type.equalsIgnoreCase("SFTP") ? "22" : "21";
        }
        try {
            if ("SFTP".equalsIgnoreCase(ftpSubProtocol)) {
                this.processSftp(event, server, port, user, password, path, insecureSSH);
            }
            if ("FTPS".equalsIgnoreCase(ftpSubProtocol)) {
                this.processFtps(event, server, port, user, password, path, true);
            }
            if ("FTP".equalsIgnoreCase(ftpSubProtocol)) {
                this.processFtps(event, server, port, user, password, path, false);
            }
            event.setResult(1);
        }
        catch (Exception e) {
            logger.severe("File transfer error: " + e.getMessage());
            this.documentImportService.logMessage("\u251c\u2500\u2500 \u26a0\ufe0f Transfer failed: " + e.getMessage(), event);
            event.setResult(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFtps(DocumentImportEvent event, String host, String port, String user, String pass, String path, boolean tls) throws Exception {
        FTPSClient ftpClient = tls ? new FTPSClient("TLS", false) : new FTPClient();
        try {
            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \ud83d\udd10 Connecting to " + (tls ? "FTPS" : "FTP") + " server: " + host + "...", event);
            ftpClient.connect(host, Integer.parseInt(port));
            if (!ftpClient.login(user, pass)) {
                throw new IOException("Login failed for user " + user);
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setControlEncoding("UTF-8");
            boolean changed = ftpClient.changeWorkingDirectory(path);
            if (!changed) {
                throw new IOException("Unable to change working directory to: " + path);
            }
            FTPFile[] files = ftpClient.listFiles();
            if (files.length == 0) {
                this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Directory empty: " + path, event);
                return;
            }
            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 connection successful!", event);
            for (FTPFile file : files) {
                if (!file.isFile()) continue;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    ftpClient.retrieveFile(file.getName(), (OutputStream)os);
                    byte[] data = os.toByteArray();
                    if (data.length > 0) {
                        this.createWorkitem(event.getSource(), file.getName(), data);
                        try {
                            ftpClient.deleteFile(file.getName());
                        }
                        catch (IOException ee) {
                            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Failed to remove file from source directory: " + ee.getMessage(), event);
                            throw ee;
                        }
                        this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u2705 Imported " + file.getName(), event);
                        continue;
                    }
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Empty file ignored: " + file.getName(), event);
                }
            }
            this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Completed.", event);
        }
        finally {
            try {
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSftp(DocumentImportEvent event, String host, String port, String user, String pass, String path, boolean insecureSSH) throws Exception {
        this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \ud83d\udd10 Connecting to SFTP server: " + host + "...", event);
        SSHClient ssh = new SSHClient();
        if (insecureSSH) {
            ssh.addHostKeyVerifier(new HostKeyVerifier(){

                public boolean verify(String hostname, int port, PublicKey key) {
                    return true;
                }

                public List<String> findExistingAlgorithms(String hostname, int port) {
                    return Collections.emptyList();
                }
            });
        } else {
            ssh.loadKnownHosts();
        }
        ssh.connect(host, Integer.parseInt(port));
        ssh.authPassword(user, pass);
        try (SFTPClient sftp = ssh.newSFTPClient();){
            List files = sftp.ls(path);
            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 connection successful!", event);
            if (files.isEmpty()) {
                this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Directory empty: " + path, event);
                return;
            }
            for (RemoteResourceInfo file : files) {
                if (file.isDirectory()) continue;
                RemoteFile remoteFile = sftp.open(file.getPath());
                try (RemoteFile.RemoteFileInputStream is = new RemoteFile.RemoteFileInputStream(remoteFile);
                     ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    is.transferTo(os);
                    byte[] data = os.toByteArray();
                    if (data.length > 0) {
                        this.createWorkitem(event.getSource(), file.getName(), data);
                        try {
                            sftp.rm(file.getPath());
                        }
                        catch (IOException ee) {
                            this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Failed to remove file from source directory: " + ee.getMessage(), event);
                            throw ee;
                        }
                        this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u2705 Imported " + file.getName(), event);
                        continue;
                    }
                    this.documentImportService.logMessage("\u2502   \u251c\u2500\u2500 \u26a0\ufe0f Empty file ignored: " + file.getName(), event);
                }
                finally {
                    if (remoteFile == null) continue;
                    remoteFile.close();
                }
            }
            this.documentImportService.logMessage("\u2514\u2500\u2500 \u2705 Completed.", event);
        }
        finally {
            ssh.close();
            ssh.disconnect();
        }
    }

    public ItemCollection createWorkitem(ItemCollection source, String fileName, byte[] rawData) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        workitem.setItemValue("document.import.type", (Object)source.getItemValue("type"));
        workitem.setItemValue("document.import.selector", (Object)source.getItemValue("selector"));
        workitem.setItemValue("document.import.options", (Object)source.getItemValue("options"));
        String contentType = "*/*";
        if (fileName.toLowerCase().endsWith(".pdf")) {
            contentType = "application/pdf";
        }
        FileData fileData = new FileData(fileName, rawData, contentType, null);
        workitem.addFileData(fileData);
        workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
        return workitem;
    }
}

