/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.importer.mail;

import jakarta.inject.Named;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.importer.mail.IMAPAuthenticator;

@Named
public class IMAPBasicAuthenticator
implements IMAPAuthenticator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(IMAPBasicAuthenticator.class.getName());

    @Override
    public Store openMessageStore(ItemCollection sourceConfig, Properties sourceOptions) throws MessagingException {
        String imapServer = sourceConfig.getItemValueString("server");
        String imapPort = sourceConfig.getItemValueString("port");
        String imapUser = sourceConfig.getItemValueString("user");
        String imapPassword = sourceConfig.getItemValueString("password");
        Properties imapProperties = new Properties();
        imapProperties.setProperty("mail.store.protocol", "imaps");
        Enumeration<?> enums = sourceOptions.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            if (!key.startsWith("mail.")) continue;
            imapProperties.setProperty(key, sourceOptions.getProperty(key));
            logger.info("......setting property from source options: " + key);
        }
        if (imapProperties.containsKey("mail.imap.port")) {
            imapPort = imapProperties.getProperty("mail.imap.port");
        }
        if (imapPort.isEmpty()) {
            imapPort = "993";
        }
        Session session = Session.getDefaultInstance((Properties)imapProperties, null);
        Store store = session.getStore();
        store.connect(imapServer, Integer.parseInt(imapPort), imapUser, imapPassword);
        return store;
    }
}

