/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.dataview;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.SessionScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.dataview.DataViewService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.AbstractDataController;
import org.imixs.workflow.faces.data.DocumentController;

@Named
@SessionScoped
public class DataViewDefinitionController
extends AbstractDataController {
    private static final long serialVersionUID = 1L;
    protected List<ItemCollection> attributeList = null;
    @Inject
    DocumentController documentController;
    @Inject
    protected DataViewService dataViewService;
    protected List<ItemCollection> dataViewDefinitions = null;
    private static Logger logger = Logger.getLogger(DataViewDefinitionController.class.getName());

    @PostConstruct
    public void init() {
    }

    public List<ItemCollection> getDefinitions() {
        if (this.dataViewDefinitions == null) {
            String quuery = "(type:\"dataview\")";
            try {
                this.dataViewDefinitions = this.getDocumentService().find(quuery, 999, 0, "name", false);
            }
            catch (QueryException e) {
                logger.severe("Failed to load DataView definition list: " + e.getMessage());
            }
        }
        return this.dataViewDefinitions;
    }

    public List<ItemCollection> findDefinitionByProcessRef(String id) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (id == null) {
            return result;
        }
        this.getDefinitions();
        for (ItemCollection def : this.dataViewDefinitions) {
            if (!id.equals(def.getItemValueString("process.ref"))) continue;
            result.add(def);
        }
        return result;
    }

    public ItemCollection getData() {
        if (this.data == null) {
            this.reset();
        }
        return this.data;
    }

    public String getViewURI(ItemCollection dataDef) {
        return "/pages/dataviews/data.xhtml?id=" + dataDef.getUniqueID() + "&faces-redirect=true";
    }

    public void load(String uniqueid) {
        super.load(uniqueid);
        this.attributeList = this.dataViewService.computeDataViewItemDefinitions(this.data);
    }

    public void create() {
        this.data = new ItemCollection();
        this.data.setType("dataview");
    }

    public void save() throws AccessDeniedException {
        this.data.setType("dataview");
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        this.data.replaceItemValue("$editor", (Object)sUser);
        if (this.attributeList != null) {
            ArrayList<Map> mapItemList = new ArrayList<Map>();
            logger.fine("Convert attribute items into Map...");
            for (ItemCollection attrItem : this.attributeList) {
                ItemCollection ding = (ItemCollection)attrItem.clone();
                mapItemList.add(ding.getAllItems());
            }
            this.data.replaceItemValue("dataview.items", mapItemList);
        }
        this.data = this.getDocumentService().save(this.data);
        this.dataViewDefinitions = null;
    }

    public String openTestView() {
        this.save();
        return "/pages/dataviews/data.xhtml?id=" + this.data.getUniqueID() + "&faces-redirect=true";
    }

    public List<ItemCollection> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<ItemCollection>();
        }
        return this.attributeList;
    }

    public void addAttribute() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<ItemCollection>();
        }
        ItemCollection source = new ItemCollection();
        this.attributeList.add(source);
    }

    public void removeAttribute(String name) {
        if (name != null && this.attributeList != null) {
            for (ItemCollection item : this.attributeList) {
                if (!name.equals(item.getItemValueString("item.name"))) continue;
                this.attributeList.remove(item);
                break;
            }
        }
    }

    public void moveAttributeUp(String name) {
        if (name != null && this.attributeList != null) {
            logger.fine("move up: " + name);
            for (int i = 0; i < this.attributeList.size(); ++i) {
                ItemCollection item = this.attributeList.get(i);
                if (!name.equals(item.getItemValueString("item.name"))) continue;
                if (i <= 0) break;
                Collections.swap(this.attributeList, i, i - 1);
                break;
            }
        }
    }

    public void moveAttributeDown(String name) {
        if (name != null && this.attributeList != null) {
            logger.fine("move down: " + name);
            for (int i = 0; i < this.attributeList.size(); ++i) {
                ItemCollection item = this.attributeList.get(i);
                if (!name.equals(item.getItemValueString("item.name"))) continue;
                if (i >= this.attributeList.size() - 1) break;
                Collections.swap(this.attributeList, i, i + 1);
                break;
            }
        }
    }
}

