/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.dataview;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class DataViewPOIHelper {
    private static Logger logger = Logger.getLogger(DataViewPOIHelper.class.getName());
    public static final String ERROR_CONFIG = "CONFIG_ERROR";

    public static void downloadExcelFile(FileData fileData) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.responseReset();
        externalContext.setResponseContentType("application/vnd.ms-excel");
        externalContext.setResponseContentLength(fileData.getContent().length);
        externalContext.setResponseHeader("Content-Disposition", "attachment; filename=\"" + fileData.getName() + "\"");
        OutputStream output = externalContext.getResponseOutputStream();
        output.write(fileData.getContent());
        facesContext.responseComplete();
    }

    public static void poiUpdate(ItemCollection dataDefinition, FileData fileData, ItemCollection poiConfig, WorkflowService workflowService) throws PluginException {
        dataDefinition.setItemValue("$modified", (Object)new Date());
        if (poiConfig == null || !poiConfig.hasItem("findreplace")) {
            return;
        }
        List replaceDevList = poiConfig.getItemValue("findreplace");
        String eval = poiConfig.getItemValueString("eval");
        try (ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)imputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            DataViewPOIHelper.updateXSSFWorkbook(workbook, dataDefinition, replaceDevList, workflowService);
            if (eval != null && !eval.isEmpty()) {
                String[] cellPositions;
                for (String cellPos : cellPositions = eval.split(";")) {
                    DataViewPOIHelper.evalXSSFSheet(workbook, sheet, cellPos);
                }
                logger.fine("formula evaluation completed");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            workbook.close();
            byte[] newContent = byteArrayOutputStream.toByteArray();
            fileData.setContent(newContent);
        }
        catch (IOException e) {
            throw new PluginException(DataViewPOIHelper.class.getSimpleName(), ERROR_CONFIG, "failed to update excel export: " + e.getMessage());
        }
    }

    public static XSSFCell getCellByRef(XSSFWorkbook doc, XSSFSheet sheet, String cellReference) {
        CellReference cr;
        XSSFRow row;
        XSSFCell cell = null;
        XSSFName aNamedCell = doc.getName(cellReference);
        if (aNamedCell != null) {
            logger.finest("...resolving named cell = " + aNamedCell.getNameName());
            cellReference = aNamedCell.getRefersToFormula();
        }
        if ((row = sheet.getRow((cr = new CellReference(cellReference)).getRow())) == null) {
            logger.severe("Unable to resolve cell ref '" + cellReference + "'!");
            return null;
        }
        cell = row.getCell((int)cr.getCol());
        return cell;
    }

    public static void updateXSSFWorkbook(XSSFWorkbook workbook, ItemCollection workitem, List<String> replaceDevList, WorkflowService workflowService) throws PluginException {
        logger.fine("XSSFWorkbook loaded");
        XSSFSheet sheet = workbook.getSheetAt(0);
        for (String entityDev : replaceDevList) {
            ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
            if (entityData == null) continue;
            String find = entityData.getItemValueString("find");
            String replace = entityData.getItemValueString("replace");
            replace = workflowService.adaptText(replace, workitem);
            String itemname = entityData.getItemValueString("itemname");
            if (!itemname.isEmpty()) {
                List valueList = workitem.getItemValue(itemname);
                if (valueList.size() <= 0) continue;
                DataViewPOIHelper.replaceXSSFSheetItemValue(workbook, sheet, find, valueList.get(0));
                continue;
            }
            DataViewPOIHelper.replaceXSSFSheetStringValue(workbook, sheet, find, replace);
        }
    }

    public static void replaceXSSFSheetItemValue(XSSFWorkbook doc, XSSFSheet sheet, String find, Object itemValue) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = DataViewPOIHelper.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        if (itemValue instanceof Date) {
            cell.setCellValue((Date)itemValue);
        } else if (itemValue instanceof Double) {
            cell.setCellValue(((Double)itemValue).doubleValue());
        } else {
            cell.setCellValue(itemValue.toString());
        }
    }

    private static void replaceXSSFSheetStringValue(XSSFWorkbook doc, XSSFSheet sheet, String find, String replace) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = DataViewPOIHelper.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        try {
            float f = Float.parseFloat(replace);
            cell.setCellValue((double)f);
        }
        catch (NumberFormatException e) {
            cell.setCellValue(replace);
        }
    }

    public static void evalXSSFSheet(XSSFWorkbook doc, XSSFSheet sheet, String cell) throws PluginException {
        XSSFFormulaEvaluator evaluator = doc.getCreationHelper().createFormulaEvaluator();
        XSSFCell c = DataViewPOIHelper.getCellByRef(doc, sheet, cell);
        if (c == null) {
            logger.warning("Cell " + cell + " not found.");
            return;
        }
        if (c.getCellType() == CellType.FORMULA) {
            logger.finest("...eval cell " + cell);
            try {
                CellType evalResult = evaluator.evaluateFormulaCell((Cell)c);
                if (evalResult == CellType.ERROR) {
                    logger.warning("...unable to evaluate cell " + cell);
                }
            }
            catch (Exception poie) {
                logger.warning("...failed to evaluate cell " + cell + " : " + poie.getMessage());
            }
        }
    }
}

