/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.dataview;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.dataview.DataViewCache;
import org.imixs.workflow.dataview.DataViewDefinitionController;
import org.imixs.workflow.dataview.DataViewPOIHelper;
import org.imixs.workflow.dataview.DataViewService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.data.ViewHandler;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@ConversationScoped
public class DataViewController
extends ViewController {
    private static final long serialVersionUID = 1L;
    protected List<ItemCollection> viewItemDefinitions = null;
    protected ItemCollection dataViewDefinition = null;
    protected ItemCollection filter;
    protected String query;
    protected String errorMessage;
    @Inject
    protected DataViewCache dataViewCache;
    @Inject
    protected Conversation conversation;
    @Inject
    protected DocumentService documentService;
    @Inject
    protected WorkflowService workflowService;
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected DataViewService dataViewService;
    @Inject
    protected ViewHandler viewHandler;
    @Inject
    protected DataViewDefinitionController dataViewDefinitionController;
    private String lastDataViewName = null;
    private static Logger logger = Logger.getLogger(DataViewController.class.getName());

    @PostConstruct
    public void init() {
        super.init();
        this.setSortBy("$modified");
        this.setSortReverse(false);
        this.setPageSize(100);
        this.setLoadStubs(false);
    }

    public void onLoad() {
        String uniqueid = null;
        this.startConversation();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.isPostback() && !facesContext.isValidationFailed()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            Map paramMap = fc.getExternalContext().getRequestParameterMap();
            uniqueid = (String)paramMap.get("id");
            if (uniqueid == null || uniqueid.isEmpty()) {
                uniqueid = (String)paramMap.get("workitem");
            }
            this.dataViewDefinition = this.documentService.load(uniqueid);
        }
        this.filter = uniqueid != null && !uniqueid.isEmpty() ? this.dataViewCache.get(uniqueid) : new ItemCollection();
        try {
            if (this.dataViewDefinition != null) {
                this.filter.setItemValue("txtWorkflowEditorCustomForm", (Object)this.dataViewDefinition.getItemValue("form"));
                this.filter.setItemValue("name", (Object)this.dataViewDefinition.getItemValueString("name"));
                this.filter.setItemValue("description", (Object)this.dataViewDefinition.getItemValueString("description"));
                this.viewItemDefinitions = this.dataViewService.computeDataViewItemDefinitions(this.dataViewDefinition);
                String sortBy = this.dataViewDefinition.getItemValueString("sort.by");
                if (sortBy.isEmpty()) {
                    sortBy = "$modified";
                }
                this.setSortBy(sortBy);
                this.setSortReverse(this.dataViewDefinition.getItemValueBoolean("sort.reverse"));
                this.setPageIndex(this.filter.getItemValueInteger("pageIndex"));
                this.run();
            }
        }
        catch (PluginException | QueryException e) {
            logger.warning("Failed to load dataview definition: " + e.getMessage());
        }
    }

    public ItemCollection getDataViewDefinition() {
        return this.dataViewDefinition;
    }

    public List<ItemCollection> getViewItemDefinitions() {
        return this.viewItemDefinitions;
    }

    public List<ItemCollection> getViewItemDefinitions(String dataView) {
        if (this.viewItemDefinitions == null || !Objects.equals(dataView, this.lastDataViewName)) {
            this.lastDataViewName = dataView;
            this.dataViewDefinition = this.dataViewService.loadDataViewDefinition(dataView);
            if (this.dataViewDefinition != null) {
                this.viewItemDefinitions = this.dataViewService.computeDataViewItemDefinitions(this.dataViewDefinition);
            }
        }
        return this.viewItemDefinitions;
    }

    public ItemCollection getFilter() {
        return this.filter;
    }

    public void setFilter(ItemCollection filter) {
        this.filter = filter;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void run() throws PluginException, QueryException {
        this.reset();
        this.query = this.dataViewDefinition.getItemValueString("query");
        this.query = this.parseQuery(this.query, this.filter);
        this.query = this.parseQuery(this.query, this.workflowController.getWorkitem());
        logger.info("query=" + this.query);
        this.filter.setItemValue("query", (Object)this.query);
        this.viewHandler.getData((ViewController)this);
        this.dataViewCache.put(this.dataViewDefinition.getUniqueID(), this.filter);
    }

    private String parseQuery(String query, ItemCollection filter) {
        List filterItems = filter.getItemNames();
        for (String itemName : filterItems) {
            String itemValue = filter.getItemValueString(itemName);
            if (filter.getItemValueDate(itemName) != null) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
                itemValue = dateformat.format(filter.getItemValueDate(itemName));
            }
            query = query.replaceAll("(?i)\\{" + Pattern.quote(itemName) + "\\}", itemValue);
        }
        Pattern pattern = Pattern.compile("\\{[^}]*\\}");
        Matcher matcher = pattern.matcher(query);
        query = matcher.replaceAll("*");
        query = query.replace("**", "*");
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    public void back() {
        this.viewHandler.back((ViewController)this);
        this.filter.setItemValue("pageIndex", (Object)this.getPageIndex());
    }

    public void forward() {
        this.viewHandler.forward((ViewController)this);
        this.filter.setItemValue("pageIndex", (Object)this.getPageIndex());
    }

    protected void startConversation() {
        if (this.conversation.isTransient()) {
            this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
            this.conversation.begin();
            logger.log(Level.FINEST, "......start new conversation, id={0}", this.conversation.getId());
        }
    }

    public String export() throws PluginException, QueryException {
        this.run();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
        Object targetFileName = this.dataViewDefinition.getItemValueString("poi.targetFilename");
        if (((String)targetFileName).isEmpty()) {
            throw new PluginException(DataViewController.class.getSimpleName(), "CONFIG_ERROR", "Missing Excel Export definition - check configuration!");
        }
        targetFileName = (String)targetFileName + "_" + dateformat.format(new Date()) + ".xlsx";
        logger.info("start export : " + (String)targetFileName + "...");
        logger.fine(this.query);
        FileData templateFileData = this.dataViewService.loadTemplate(this.dataViewDefinition);
        try {
            List workitems;
            int totalCount = this.documentService.count(this.query);
            if (totalCount > 9999) {
                throw new PluginException(DataViewController.class.getSimpleName(), "CONFIG_ERROR", "Data can not be exported into Excel because dataset exceeds 9999 rows!");
            }
            String sortBy = this.dataViewDefinition.getItemValueString("sort.by");
            if (sortBy.isEmpty()) {
                sortBy = "$modified";
            }
            if ((workitems = this.documentService.find(this.query, 9999, 0, sortBy, this.dataViewDefinition.getItemValueBoolean("sort.reverse"))).size() > 0) {
                this.dataViewService.poiExport(workitems, this.dataViewDefinition, this.viewItemDefinitions, templateFileData);
            }
            ItemCollection event = new ItemCollection().setItemValue("txtActivityResult", (Object)this.dataViewDefinition.getItemValue("poi.update"));
            ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", this.dataViewDefinition, false);
            this.filter.copy(this.workflowController.getWorkitem());
            DataViewPOIHelper.poiUpdate(this.filter, templateFileData, poiConfig, this.workflowService);
            templateFileData.setName((String)targetFileName);
            DataViewPOIHelper.downloadExcelFile(templateFileData);
        }
        catch (IOException | QueryException e) {
            throw new PluginException(DataViewController.class.getSimpleName(), "CONFIG_ERROR", "Failed to generate Excel Export: " + e.getMessage());
        }
        return "";
    }
}

