/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.dataview;

import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.dataview.DataViewController;
import org.imixs.workflow.dataview.DataViewExportEvent;
import org.imixs.workflow.dataview.DataViewPOIHelper;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

@Stateless
@LocalBean
public class DataViewService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DataViewService.class.getName());
    public static final String ITEM_WORKITEMREF = "$workitemref";
    public static final int MAX_ROWS = 9999;
    public static final String ERROR_API = "API_ERROR";
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    @Inject
    protected WorkflowService workflowService;
    @Inject
    protected DocumentService documentService;
    @Inject
    protected SnapshotService snapshotService;
    @Inject
    protected Event<DataViewExportEvent> dataViewExportEvents;

    public ItemCollection loadDataViewDefinition(String dataView) {
        long l = System.currentTimeMillis();
        ItemCollection dataViewDefinition = null;
        try {
            String query = "(type:dataview) AND (name:\"" + dataView + "\")";
            List result = this.documentService.find(query, 1, 0);
            if (result.size() > 0) {
                dataViewDefinition = (ItemCollection)result.get(0);
            }
            logger.fine("getViewItemDefinitions: " + dataView + " took: " + (System.currentTimeMillis() - l) + "ms");
        }
        catch (QueryException e) {
            logger.warning("DataView '" + dataView + "' is not defined!");
        }
        return dataViewDefinition;
    }

    public List<ItemCollection> computeDataViewItemDefinitions(ItemCollection dataViewDefinition) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List mapItems = dataViewDefinition.getItemValue("dataview.items");
        for (Object mapOderItem : mapItems) {
            String itemType;
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            String itemLabel = itemCol.getItemValueString("item.label");
            if (itemLabel.isEmpty()) {
                itemCol.setItemValue("item.label", (Object)itemLabel);
            }
            if ((itemType = itemCol.getItemValueString("item.type")).isEmpty()) {
                itemCol.setItemValue("item.type", (Object)"xs:string");
            }
            result.add(itemCol);
        }
        if (result.size() == 0) {
            ItemCollection itemCol = new ItemCollection();
            itemCol.setItemValue("item.name", (Object)"$workflowSummary");
            itemCol.setItemValue("item.label", (Object)"Name");
            itemCol.setItemValue("item.type", (Object)"xs:anyURI");
            result.add(itemCol);
            itemCol = new ItemCollection();
            itemCol.setItemValue("item.name", (Object)"$modified");
            itemCol.setItemValue("item.label", (Object)"Modified");
            itemCol.setItemValue("item.type", (Object)"xs:date");
            result.add(itemCol);
        }
        return result;
    }

    public FileData loadTemplate(ItemCollection dataViewDefinition) throws PluginException {
        List fileDataList = dataViewDefinition.getFileData();
        if (fileDataList != null && fileDataList.size() > 0) {
            String fileName = ((FileData)fileDataList.get(0)).getName();
            return this.snapshotService.getWorkItemFile(dataViewDefinition.getUniqueID(), fileName);
        }
        throw new PluginException(DataViewController.class.getSimpleName(), ERROR_CONFIG, "Missing Excel Export Template - check DataView definition!");
    }

    public void poiExport(List<ItemCollection> dataset, ItemCollection dataViewDefinition, List<ItemCollection> viewItemDefinitions, FileData fileData) throws PluginException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getContent());){
            XSSFWorkbook doc = new XSSFWorkbook((InputStream)inputStream);
            if (this.dataViewExportEvents != null) {
                DataViewExportEvent event = new DataViewExportEvent(dataset, dataViewDefinition, viewItemDefinitions, doc);
                this.dataViewExportEvents.fire((Object)event);
                if (!event.isCompleted()) {
                    this.insertRows(dataset, dataViewDefinition, viewItemDefinitions, doc);
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            byte[] newContent = byteArrayOutputStream.toByteArray();
            fileData.setContent(newContent);
        }
        catch (IOException e) {
            throw new PluginException(DataViewPOIHelper.class.getSimpleName(), ERROR_CONFIG, "failed to update excel export: " + e.getMessage());
        }
    }

    private void insertRows(List<ItemCollection> dataset, ItemCollection dataViewDefinition, List<ItemCollection> viewItemDefinitions, XSSFWorkbook doc) {
        int referenceRowPos;
        String referenceCell = dataViewDefinition.getItemValueString("poi.referenceCell");
        XSSFSheet sheet = doc.getSheetAt(0);
        CellReference cr = new CellReference(referenceCell);
        XSSFRow referenceRow = sheet.getRow(cr.getRow());
        int rowPos = referenceRowPos = referenceRow.getRowNum() + 1;
        int lastRow = 999;
        logger.finest("Last rownum=" + lastRow);
        sheet.shiftRows(rowPos, lastRow, dataset.size(), true, true);
        for (ItemCollection workitem : dataset) {
            logger.finest("......copy row...");
            XSSFRow row = sheet.createRow(rowPos);
            row.copyRowFrom((Row)referenceRow, new CellCopyPolicy());
            int cellNum = 0;
            for (ItemCollection itemDef : viewItemDefinitions) {
                String type = itemDef.getItemValueString("item.type");
                String name = itemDef.getItemValueString("item.name");
                switch (type) {
                    case "xs:double": {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueDouble(name));
                        break;
                    }
                    case "xs:float": {
                        row.getCell(cellNum).setCellValue((double)workitem.getItemValueFloat(name));
                        break;
                    }
                    case "xs:int": {
                        row.getCell(cellNum).setCellValue((double)workitem.getItemValueInteger(name));
                        break;
                    }
                    case "xs:date": {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueDate(name));
                        break;
                    }
                    default: {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueString(name));
                    }
                }
                ++cellNum;
            }
            ++rowPos;
        }
        sheet.shiftRows(referenceRowPos, lastRow + dataset.size(), -1, true, true);
    }
}

