/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.ejb.EJB;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;

public class DeputyPlugin
extends AbstractPlugin {
    public static String PROFILESERVICE_NOT_BOUND = "PROFILESERVICE_NOT_BOUND";
    ItemCollection workitem = null;
    private String[] ignoreList = new String[]{"$creator", "$editor", "$lasteditor", "namcreator", "namcurrenteditor", "namlasteditor", "$owner", "namowner", "nam+(?:[a-z0-9_]+)approvers", "nam+(?:[a-z0-9_]+)approvedby"};
    private String[] supportList = new String[]{"\\.manager$", "\\.team$", "\\.assist$"};
    private static Logger logger = Logger.getLogger(DeputyPlugin.class.getName());
    @EJB
    ProfileService profileService;

    public ItemCollection run(ItemCollection aworkItem, ItemCollection documentActivity) {
        this.workitem = aworkItem;
        String type = this.workitem.getItemValueString("type");
        if (!type.startsWith("workitem") && !type.startsWith("childworkitem")) {
            return this.workitem;
        }
        Map map = this.workitem.getAllItems();
        for (String itemName : map.keySet()) {
            if (this.ignoreItem(itemName)) continue;
            logger.fine("... lookup=" + itemName);
            List oldNameList = this.workitem.getItemValue(itemName);
            List<String> newNameList = this.updateDeputies(oldNameList);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("... new list=");
                for (String aentry : newNameList) {
                    logger.fine(aentry);
                }
            }
            this.workitem.replaceItemValue(itemName, newNameList);
        }
        return this.workitem;
    }

    private List<String> updateDeputies(List<String> sourceNameList) {
        Vector<String> resultNameList = new Vector<String>();
        resultNameList.addAll(sourceNameList);
        for (String aName : sourceNameList) {
            ItemCollection profile = this.profileService.findProfileById(aName);
            if (profile == null) continue;
            List deputyList = profile.getItemValue("namdeputy");
            for (String deputy : deputyList) {
                if (deputy == null || deputy.isEmpty() || resultNameList.indexOf(deputy) != -1) continue;
                resultNameList.add(deputy);
            }
        }
        return resultNameList;
    }

    public String[] getIgnoreList() {
        return this.ignoreList;
    }

    public void setIgnoreList(String[] ignoreList) {
        this.ignoreList = ignoreList;
    }

    public boolean ignoreItem(String itemName) {
        Pattern p;
        if (itemName == null) {
            return true;
        }
        for (String pattern : this.supportList) {
            p = Pattern.compile(pattern);
            if (!p.matcher(itemName.toLowerCase()).find()) continue;
            return false;
        }
        for (String pattern : this.ignoreList) {
            p = Pattern.compile(pattern);
            if (!p.matcher(itemName.toLowerCase()).find()) continue;
            return true;
        }
        return !itemName.toLowerCase().startsWith("nam");
    }
}

