/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.ejb.EJB;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

public class MailPlugin
extends org.imixs.workflow.engine.plugins.MailPlugin {
    public static String SNAPSHOTID = "$snapshotid";
    public static String PROFILESERVICE_NOT_BOUND = "PROFILESERVICE_NOT_BOUND";
    public static String PROPERTYSERVICE_NOT_BOUND = "PROPERTYSERVICE_NOT_BOUND";
    public static String INVALID_EMAIL = "INVALID_EMAIL";
    private static Logger logger = Logger.getLogger(MailPlugin.class.getName());
    @EJB
    DocumentService documentService;
    @EJB
    ProfileService profileService;

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        ItemCollection result = super.run(documentContext, documentActivity);
        MimeMessage mailMessage = (MimeMessage)super.getMailMessage();
        if (mailMessage != null) {
            String content = null;
            MimeBodyPart messagePart = null;
            Multipart multipart = super.getMultipart();
            try {
                messagePart = (MimeBodyPart)multipart.getBodyPart(0);
                content = (String)messagePart.getContent();
            }
            catch (MessagingException | IOException | ArrayIndexOutOfBoundsException e) {
                logger.warning("Unable to parse tag 'attachments' !");
                e.printStackTrace();
                return null;
            }
            if (content != null && content.toLowerCase().indexOf("<attachments") != -1) {
                try {
                    content = this.attachFiles(documentContext, content);
                }
                catch (MessagingException e) {
                    logger.warning("unable to attach files!");
                    e.printStackTrace();
                }
                try {
                    messagePart.setContent((Object)content, this.getContentType());
                }
                catch (MessagingException e) {
                    logger.warning("Unable to parse tag 'attachments' !");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        if (aAddr.indexOf(64) > -1) {
            return super.getInternetAddress(aAddr);
        }
        try {
            aAddr = this.fetchEmail(aAddr);
            if (aAddr.indexOf(64) == -1) {
                logger.warning("smtp mail address for '" + aAddr + "' could not be resolved!");
                return null;
            }
        }
        catch (NamingException e) {
            logger.warning("smtp mail address for '" + aAddr + "' could not be resolved - " + e.getMessage());
            return null;
        }
        return super.getInternetAddress(aAddr);
    }

    private String fetchEmail(String aUserID) throws NamingException {
        ItemCollection itemColProfile = this.profileService.findProfileById(aUserID);
        if (itemColProfile == null) {
            throw new NamingException("No Profile found for: " + aUserID);
        }
        String sEmail = itemColProfile.getItemValueString("txtEmail");
        logger.fine("ProfileService - EmailLookup =" + sEmail);
        if (sEmail != null && !"".equals(sEmail)) {
            if (sEmail.indexOf("http") > -1 || sEmail.indexOf("//") > -1) {
                throw new NamingException("Invalid Email: ID=" + aUserID + " Email=" + sEmail);
            }
            return sEmail;
        }
        if (aUserID.indexOf("http") > -1 || aUserID.indexOf("//") > -1) {
            throw new NamingException("Invalid Email: ID=" + aUserID);
        }
        return aUserID;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String attachFiles(ItemCollection workitem, String content) throws MessagingException {
        logger.finest("......attaching files");
        ItemCollection attachmentContext = null;
        if (content == null) return content;
        if (content.isEmpty()) {
            return content;
        }
        List tags = XMLParser.findTags((String)content, (String)"attachments");
        Iterator iterator = tags.iterator();
        while (true) {
            ItemCollection snapshotWorkitem;
            String _tag;
            block15: {
                if (!iterator.hasNext()) {
                    return content;
                }
                _tag = (String)iterator.next();
                attachmentContext = null;
                logger.finest("......attachments tag=" + _tag);
                if (_tag.contains("textblock")) {
                    String textblockName = XMLParser.findAttribute((String)_tag, (String)"textblock");
                    logger.finest("......attaching textblock " + textblockName);
                    if (textblockName != null && !textblockName.isEmpty()) {
                        ItemCollection textBlockDocument = this.loadTextBlock(textblockName);
                        if (textBlockDocument == null) {
                            logger.warning("textblock '" + textblockName + "' is not defined!");
                            content = content.replace(_tag, "");
                            continue;
                        }
                        if (!"FILE".equals(textBlockDocument.getItemValueString("txtmode"))) {
                            logger.warning("textblock '" + textblockName + "' is not defined as type FILE!");
                            content = content.replace(_tag, "");
                            continue;
                        }
                        attachmentContext = textBlockDocument;
                        break block15;
                    } else {
                        logger.warning("wrong or empty attribute  'textblock' in tag " + _tag + " - please verify model!");
                        continue;
                    }
                }
                attachmentContext = workitem;
            }
            if ((snapshotWorkitem = this.getWorkflowService().getDocumentService().load(attachmentContext.getItemValueString(SNAPSHOTID))) != null) {
                // empty if block
            }
            String sFilePattern = XMLParser.findTagValue((String)_tag, (String)"attachments");
            sFilePattern = sFilePattern.trim();
            logger.finest("......MailPlugin attach file pattern: \"" + sFilePattern + "\"");
            List fileNames = attachmentContext.getFileNames();
            Pattern pattern = null;
            if (!sFilePattern.isEmpty()) {
                pattern = Pattern.compile(sFilePattern);
            }
            logger.finest("......total count of file=" + fileNames.size());
            for (String aFileName : fileNames) {
                FileData fileData;
                if (pattern != null && !pattern.matcher(aFileName).find() || (fileData = attachmentContext.getFileData(aFileName)) == null) continue;
                if (fileData.getContent().length < 4) {
                    logger.finest("......file found, but we need a snapshot....");
                    if (snapshotWorkitem != null) {
                        fileData = snapshotWorkitem.getFileData(aFileName);
                        if (fileData == null) {
                            continue;
                        }
                    } else {
                        logger.warning("Snapshot is missing - can not attache file!!");
                    }
                }
                logger.finest("......MailPlugin - attach : " + aFileName);
                Multipart multipart = super.getMultipart();
                MimeBodyPart attachmentPart = new MimeBodyPart();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(fileData.getContent(), fileData.getContentType());
                attachmentPart.setDataHandler(new DataHandler((DataSource)dataSource));
                attachmentPart.setFileName(aFileName);
                attachmentPart.setDescription("");
                multipart.addBodyPart((BodyPart)attachmentPart);
            }
            content = content.replace(_tag, "");
        }
    }

    public ItemCollection loadTextBlock(String name) {
        ItemCollection textBlockItemCollection = null;
        textBlockItemCollection = this.documentService.load(name);
        if (textBlockItemCollection == null) {
            String sQuery = "(type:\"textblock\" AND txtname:\"" + name + "\")";
            try {
                List col = this.documentService.find(sQuery, 1, 0);
                if (col.size() > 0) {
                    textBlockItemCollection = (ItemCollection)col.iterator().next();
                } else {
                    logger.warning("Missing text-block : '" + name + "'");
                }
            }
            catch (QueryException e) {
                logger.warning("getTextBlock - invalid query: " + e.getMessage());
            }
        }
        return textBlockItemCollection;
    }
}

