/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.util.ImageCompactor;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

public class ProfilePlugin
extends AbstractPlugin {
    private String userID = null;
    private static Logger logger = Logger.getLogger(ProfilePlugin.class.getName());
    public static String USERNAME_ALREADY_TAKEN = "USERNAME_ALREADY_TAKEN";
    public static String INVALID_USERNAME = "INVALID_USERNAME";
    public static String EMAIL_ALREADY_TAKEN = "EMAIL_ALREADY_TAKEN";
    public static String INVALID_EMAIL = "INVALID_EMAIL";
    public static String NO_PROFILE_SERVICE_FOUND = "NO_PROFILE_SERVICE_FOUND";
    public static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[-A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static final String DEFAULT_USERID_PATTERN = "^[A-Za-z0-9.@\\-\\w]+";
    public static final String DEFAULT_USER_INPUT_MODE = "LOWERCASE";
    @EJB
    AdminPService adminPService;
    @EJB
    ImageCompactor imageCompactor;
    @EJB
    ProfileService profileService;
    @Inject
    @ConfigProperty(name="security.userid.input.mode", defaultValue="LOWERCASE")
    String userInputMode;
    @Inject
    @ConfigProperty(name="security.userid.input.pattern", defaultValue="^[A-Za-z0-9.@\\-\\w]+")
    String userInputPattern;
    @Inject
    @ConfigProperty(name="security.email.input.pattern", defaultValue="^[_A-Za-z0-9-\\\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[-A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")
    String emailInputPattern;
    @Inject
    @ConfigProperty(name="security.email.unique", defaultValue="true")
    String sUniqueEmailMode;
    @Inject
    @ConfigProperty(name="profile.image.maxwith", defaultValue="600")
    int imageMaxWidth;

    public ItemCollection run(ItemCollection workItem, ItemCollection documentActivity) throws PluginException {
        if ("profile".equals(workItem.getItemValueString("type"))) {
            this.validateUserProfile(workItem);
            this.userID = workItem.getItemValueString("txtName");
            try {
                this.imageCompactor.resize(workItem, this.imageMaxWidth);
            }
            catch (Exception e) {
                logger.warning("Unable to resize profile image - " + e.getMessage());
            }
            ItemCollection oldProfile = this.getWorkflowService().getDocumentService().load(workItem.getUniqueID());
            if (oldProfile != null) {
                String lastDeputy = oldProfile.getItemValueString("namdeputy");
                String currentDeputy = workItem.getItemValueString("namdeputy");
                if (!currentDeputy.isEmpty() && !currentDeputy.equals(lastDeputy)) {
                    this.createAdminPJob(currentDeputy);
                }
            }
        }
        return workItem;
    }

    private void createAdminPJob(String targetUserID) {
        logger.info("namdeputy has changed, staring new ein adminp job: " + this.userID + "=>" + targetUserID);
        if (this.adminPService != null) {
            ItemCollection adminPJob = new ItemCollection();
            adminPJob.replaceItemValue("type", (Object)"adminp");
            adminPJob.replaceItemValue("typelist", (Object)"workitem,childworkitem");
            adminPJob.replaceItemValue("namfrom", (Object)this.userID);
            adminPJob.replaceItemValue("namto\t", (Object)targetUserID);
            adminPJob.replaceItemValue("job", (Object)"RENAME_USER");
            this.adminPService.createJob(adminPJob);
        } else {
            logger.warning("Service not injected!");
        }
    }

    public void close(boolean rollbackTransaction) throws PluginException {
        if (!rollbackTransaction && this.userID != null && !this.userID.isEmpty()) {
            this.profileService.discardCache(this.userID);
        }
        super.close(rollbackTransaction);
    }

    void validateUserProfile(ItemCollection profile) throws PluginException {
        String sName = profile.getItemValueString("txtName");
        String sEmail = profile.getItemValueString("txtEmail");
        if (sName == null || "".equals(sName)) {
            throw new PluginException(ProfilePlugin.class.getSimpleName(), INVALID_USERNAME, "Missing UserID ");
        }
        if (!sName.equals(sName.trim())) {
            sName = sName.trim();
            profile.replaceItemValue("txtName", (Object)sName);
        }
        if ("lowercase".equalsIgnoreCase(this.userInputMode)) {
            sName = sName.toLowerCase();
            profile.replaceItemValue("txtName", (Object)sName);
        }
        if ("uppercase".equalsIgnoreCase(this.userInputMode)) {
            sName = sName.toUpperCase();
            profile.replaceItemValue("txtName", (Object)sName);
        }
        if (!this.isValidUserId(sName)) {
            throw new PluginException(ProfilePlugin.class.getSimpleName(), INVALID_USERNAME, "UserID did not match 'security.userid.input.pattern'=" + this.userInputPattern, new Object[]{profile.getItemValueString("txtName")});
        }
        if (!this.isValidEmailAddress(sEmail)) {
            throw new PluginException(ProfilePlugin.class.getSimpleName(), INVALID_EMAIL, "Invalid Email Address", new Object[]{profile.getItemValueString("txtEmail")});
        }
        if (this.isUserNameTaken(profile)) {
            throw new PluginException(ProfilePlugin.class.getSimpleName(), USERNAME_ALREADY_TAKEN, "Username is already taken - verifiy txtname and txtusername", new Object[]{profile.getItemValueString("txtName")});
        }
        if (this.isEmailTaken(profile)) {
            throw new PluginException(ProfilePlugin.class.getSimpleName(), EMAIL_ALREADY_TAKEN, "Email is already taken - verifiy txtemail", new Object[]{profile.getItemValueString("txtEmail")});
        }
    }

    public boolean isValidUserId(String userid) {
        if (this.userInputPattern != null && !this.userInputPattern.isEmpty()) {
            Pattern pattern = Pattern.compile(this.userInputPattern);
            Matcher matcher = pattern.matcher(userid);
            return matcher.matches();
        }
        return true;
    }

    public boolean isValidEmailAddress(String email) {
        if (email != null && !email.isEmpty()) {
            Pattern pattern = Pattern.compile(this.emailInputPattern);
            Matcher matcher = pattern.matcher(email);
            return matcher.matches();
        }
        return true;
    }

    boolean isUserNameTaken(ItemCollection profile) {
        List col;
        String sName = profile.getItemValueString("txtName");
        String sUserName = profile.getItemValueString("txtUserName");
        String sID = profile.getItemValueString("$uniqueid");
        if (!sUserName.equals(sUserName.trim())) {
            sUserName = sUserName.trim();
            profile.replaceItemValue("txtUserName", (Object)sUserName);
        }
        logger.fine("isUserNameTaken :" + sName);
        String sQuery = sUserName != null && !"".equals(sUserName) ? "(type:\"profile\" AND (txtname:\"" + sName + "\" OR txtusername:\"" + sUserName + "\")) NOT $uniqueid:\"" + sID + "\"" : "(type:\"profile\" AND txtname:\"" + sName + "\") NOT $uniqueid:\"" + sID + "\"";
        try {
            col = this.getWorkflowService().getDocumentService().find(sQuery, 1, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        return col.size() > 0;
    }

    boolean isEmailTaken(ItemCollection profile) {
        List col;
        if (!"true".equalsIgnoreCase(this.sUniqueEmailMode.trim())) {
            return false;
        }
        String sEmail = profile.getItemValueString("txtEmail");
        String sID = profile.getItemValueString("$uniqueid");
        if (sEmail.isEmpty()) {
            return false;
        }
        if (!sEmail.equals(sEmail.trim())) {
            sEmail = sEmail.trim();
            profile.replaceItemValue("txtEmail", (Object)sEmail);
        }
        logger.fine("isEmailTaken :" + sEmail);
        String sQuery = "(type:\"profile\" AND txtemail:\"" + sEmail + "\") NOT $uniqueid:\"" + sID + "\"";
        try {
            col = this.getWorkflowService().getDocumentService().find(sQuery, 1, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        return col.size() > 0;
    }
}

