/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.EJB;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Singleton;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class ProfileService {
    public static final int START_PROFILE_PROCESS_ID = 200;
    public static final int CREATE_PROFILE_ACTIVITY_ID = 5;
    final int DEFAULT_CACHE_SIZE = 100;
    final int MAX_SEARCH_COUNT = 1;
    private Cache cache;
    private static Logger logger = Logger.getLogger(ProfileService.class.getName());
    @Inject
    @ConfigProperty(name="security.userid.input.mode", defaultValue="LOWERCASE")
    String userInputMode;
    @EJB
    private DocumentService documentService;
    @Inject
    @ConfigProperty(name="setup.system.model")
    Optional<String> modelVersion;
    @EJB
    protected WorkflowService workflowService;
    @Inject
    protected Event<ProfileEvent> profileEvents;
    @Resource
    private SessionContext ctx;

    @PostConstruct
    void init() {
        this.reset();
    }

    public void reset() {
        int iCacheSize = 100;
        this.cache = new Cache(iCacheSize);
    }

    public ItemCollection findProfileById(String userid) {
        return this.findProfileById(userid, false);
    }

    public ItemCollection findProfileById(String userid, boolean refresh) {
        boolean debug = logger.isLoggable(Level.FINE);
        if (userid == null || userid.isEmpty()) {
            return null;
        }
        if ("UPPERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toUpperCase();
        }
        if ("LOWERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toLowerCase();
        }
        ItemCollection userProfile = null;
        if (!refresh) {
            Map profileMap;
            if (debug) {
                logger.info("......lookup profile '" + userid + "' from cache...");
            }
            if ((profileMap = (Map)this.cache.get(userid)) != null) {
                userProfile = new ItemCollection(profileMap);
                if (debug) {
                    logger.info("......return profile '" + userid + "' from cache");
                }
                return userProfile;
            }
        }
        if ((userProfile = this.lookupProfileById(userid)) != null) {
            userProfile = this.cloneWorkitem(userProfile);
        } else {
            if (debug) {
                logger.info("......profile '" + userid + "' not found, create a 'default' profile...");
            }
            userProfile = new ItemCollection();
            userProfile.replaceItemValue("txtname", (Object)userid);
            userProfile.replaceItemValue("txtusername", (Object)userid);
            ProfileService.computeInitials(userProfile);
        }
        if (debug) {
            logger.info("......put profile '" + userid + "' into cache");
        }
        this.cache.put(userid, userProfile.getAllItems());
        return userProfile;
    }

    public ItemCollection lookupProfileById(String userid) {
        List col;
        boolean debug = logger.isLoggable(Level.FINE);
        if (userid == null || userid.isEmpty()) {
            logger.warning("lookupProfileById - no id provided!");
            return null;
        }
        if ("UPPERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toUpperCase();
        }
        if ("LOWERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toLowerCase();
        }
        ItemCollection userProfile = null;
        if (debug) {
            logger.info("......lookupProfileById '" + userid + "'");
        }
        String sQuery = "(type:\"profile\" AND txtname:\"" + userid + "\")";
        if (debug) {
            logger.info("......search: " + sQuery);
        }
        try {
            col = this.documentService.find(sQuery, 1, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        if (col.size() > 0) {
            userProfile = (ItemCollection)col.iterator().next();
        } else {
            if (debug) {
                logger.finest("......no profile '" + userid + "' found, fire ProfileEvent LOOKUP...");
            }
            if (this.profileEvents != null) {
                ProfileEvent event = new ProfileEvent(userid, null, 1);
                this.profileEvents.fire((Object)event);
                userProfile = event.getProfile();
                if (userProfile == null && debug) {
                    logger.warning("ProfileEvent returned a null object for '" + userid + "'");
                }
            } else {
                logger.warning("CDI Support is missing - ProfileEvent wil not be fired");
            }
        }
        return userProfile;
    }

    public void discardCache(String userid) {
        this.cache.remove(userid);
    }

    public ItemCollection cloneWorkitem(ItemCollection aWorkitem) {
        ItemCollection clone = new ItemCollection();
        clone.replaceItemValue("Type", (Object)aWorkitem.getItemValue("Type"));
        clone.replaceItemValue("$UniqueID", (Object)aWorkitem.getItemValue("$UniqueID"));
        clone.replaceItemValue("$ModelVersion", (Object)aWorkitem.getItemValue("$ModelVersion"));
        clone.replaceItemValue("$ProcessID", (Object)aWorkitem.getItemValue("$ProcessID"));
        clone.replaceItemValue("$Created", (Object)aWorkitem.getItemValue("$Created"));
        clone.replaceItemValue("$Modified", (Object)aWorkitem.getItemValue("$Modified"));
        clone.replaceItemValue("$isAuthor", (Object)aWorkitem.getItemValue("$isAuthor"));
        clone.replaceItemValue("$WorkflowStatus", (Object)aWorkitem.getItemValue("$WorkflowStatus"));
        clone.replaceItemValue("$WorkflowSummary", (Object)aWorkitem.getItemValue("$WorkflowSummary"));
        clone.replaceItemValue("$WorkflowAbstract", (Object)aWorkitem.getItemValue("$WorkflowAbstract"));
        clone.replaceItemValue("txtEmail", (Object)aWorkitem.getItemValue("txtEmail"));
        clone.replaceItemValue("namdeputy", (Object)aWorkitem.getItemValue("namdeputy"));
        clone.replaceItemValue("txtusericon", (Object)aWorkitem.getItemValue("txtusericon"));
        clone.replaceItemValue("txtinitials", (Object)aWorkitem.getItemValue("txtinitials"));
        clone.replaceItemValue("txtWorkflowStatus", (Object)aWorkitem.getItemValue("txtWorkflowStatus"));
        clone.replaceItemValue("txtWorkflowSummary", (Object)aWorkitem.getItemValue("txtWorkflowSummary"));
        clone.replaceItemValue("txtWorkflowAbstract", (Object)aWorkitem.getItemValue("txtWorkflowAbstract"));
        String sAccountName = aWorkitem.getItemValueString("txtName");
        clone.replaceItemValue("txtName", (Object)sAccountName);
        String sUserName = aWorkitem.getItemValueString("txtUserName");
        if (!sUserName.isEmpty()) {
            clone.replaceItemValue("txtUserName", (Object)sUserName);
        } else {
            clone.replaceItemValue("txtUserName", (Object)sAccountName);
        }
        ProfileService.computeInitials(clone);
        return clone;
    }

    private static void computeInitials(ItemCollection profile) {
        if (profile.getItemValueString("txtinitials").isEmpty()) {
            String sAccountName = profile.getItemValueString("txtName");
            String sUserName = profile.getItemValueString("txtUserName");
            Object sInitials = "-";
            if (!sUserName.isEmpty() && sUserName.length() > 2) {
                int iPos = sUserName.indexOf(32);
                if (iPos > -1) {
                    sInitials = sUserName.substring(0, 1);
                    sInitials = (String)sInitials + sUserName.substring(iPos + 1, iPos + 2);
                } else {
                    sInitials = sUserName.substring(0, 1);
                }
            } else if (sAccountName != null && sAccountName.length() > 0) {
                sInitials = sAccountName.substring(0, 1);
            }
            profile.replaceItemValue("txtinitials", (Object)((String)sInitials).toUpperCase());
        }
    }

    public ItemCollection createProfile(String userid, String locale) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if ("UPPERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toUpperCase();
        }
        if ("LOWERCASE".equalsIgnoreCase(this.userInputMode)) {
            userid = userid.toLowerCase();
        }
        logger.info("create new profile for userid '" + userid + "'.... ");
        ItemCollection profile = new ItemCollection();
        profile.replaceItemValue("type", (Object)"profile");
        profile.replaceItemValue("$processID", (Object)200);
        if (!this.modelVersion.isPresent()) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "System Model version is missing - verify property 'setup.system.model'");
        }
        profile.replaceItemValue("$modelversion", (Object)this.modelVersion.get());
        logger.info("...creating profile based on modelversion = " + this.modelVersion.get());
        profile.replaceItemValue("txtName", (Object)userid);
        profile.replaceItemValue("txtLocale", (Object)locale);
        profile.replaceItemValue("txtgroups", (Object)"org.imixs.ACCESSLEVEL.AUTHORACCESS");
        profile.setEventID(5);
        if (this.profileEvents != null) {
            ProfileEvent event = new ProfileEvent(userid, profile, 2);
            this.profileEvents.fire((Object)event);
            profile = event.getProfile();
        } else {
            logger.warning("CDI Support is missing - ProfileEvent wil not be fired");
        }
        profile = this.workflowService.processWorkItem(profile);
        logger.finest("......new profile created for userid '" + userid + "'");
        return profile;
    }

    class Cache
    extends ConcurrentHashMap<String, Map<String, List<Object>>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public Cache(int capacity) {
            super(capacity + 1, 1.1f);
            this.capacity = capacity;
        }

        protected boolean removeEldestEntry(Map.Entry<String, ItemCollection> eldest) {
            return this.size() > this.capacity;
        }
    }
}

