/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.TextItemValueAdapter;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class TextUsernameAdapter {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
    @EJB
    ProfileService profileService;

    public void onEvent(@Observes TextEvent event) {
        Object text = event.getText();
        ItemCollection documentContext = event.getDocument();
        String sSeparator = " ";
        if (text == null) {
            return;
        }
        if (((String)text).contains("<userName") || ((String)text).contains("</userName>")) {
            logger.warning("Deprecated <userName> tag should be lowercase <username> !");
            text = ((String)text).replace("<userName", "<username");
            text = ((String)text).replace("</userName>", "</username>");
        }
        List tagList = XMLParser.findTags((String)text, (String)"username");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            sSeparator = XMLParser.findAttribute((String)tag, (String)"separator");
            String sItem = XMLParser.findAttribute((String)tag, (String)"item");
            if (sItem == null || sItem.isEmpty()) {
                sItem = "txtUserName";
            }
            String sItemValue = XMLParser.findTagValue((String)tag, (String)"username");
            List tempList = documentContext.getItemValue(sItemValue);
            Vector<String> vUserIDs = new Vector<String>(tempList);
            for (int i = 0; i < vUserIDs.size(); ++i) {
                ItemCollection profile = this.profileService.findProfileById((String)vUserIDs.get(i));
                if (profile == null) continue;
                vUserIDs.set(i, profile.getItemValueString(sItem));
            }
            TextItemValueAdapter textItemValueAdapter = new TextItemValueAdapter();
            String sResult = textItemValueAdapter.formatItemValues(vUserIDs, sSeparator, "");
            int iStartPos = ((String)text).indexOf(tag);
            int iEndPos = ((String)text).indexOf(tag) + tag.length();
            text = ((String)text).substring(0, iStartPos) + sResult + ((String)text).substring(iEndPos);
        }
        event.setText((String)text);
    }
}

