/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.security.UserGroupService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;

@Named(value="userController")
@SessionScoped
public class UserController
implements Serializable {
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String LINK_PROPERTY_DEPRECATED = "txtworkitemref";
    public static final String ITEM_USER_ICON = "user.icon";
    public static final String ITEM_SIGNATURE_IMAGE = "signature.image";
    public static final int MAX_FAVORITE_ENTRIES = 50;
    public static final int UPDATE_PROJECT_ACTIVITY_ID = 10;
    public static final String DEFAULT_LOCALE = "de_DE";
    public static final String COOKIE_LOCALE = "imixs.workflow.locale";
    @EJB
    protected ProfileService profileService;
    @EJB
    protected UserGroupService userGroupService;
    @EJB
    protected WorkflowService workflowService;
    @Inject
    protected LoginController loginController;
    @Inject
    @ConfigProperty(name="profile.login.event", defaultValue="0")
    private Provider<Integer> profileLoginEvent;
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected Event<ProfileEvent> profileEvents;
    private static final long serialVersionUID = 1L;
    private ItemCollection workitem = null;
    private boolean profileLoaded = false;
    private Locale locale;
    private static Logger logger = Logger.getLogger(UserController.class.getName());

    @PostConstruct
    public void init() throws AccessDeniedException, ProcessingErrorException {
        if (this.loginController.isAuthenticated() && !this.profileLoaded) {
            ItemCollection profile = this.profileService.lookupProfileById(this.loginController.getUserPrincipal());
            if (profile == null || profile.getModelVersion().isEmpty()) {
                try {
                    profile = this.profileService.createProfile(this.loginController.getUserPrincipal(), this.getLocale().toString());
                }
                catch (RuntimeException | ModelException | PluginException e) {
                    logger.severe("unable to create profile for userid '" + this.loginController.getUserPrincipal() + "': " + e.getMessage());
                    logger.severe("logout current userid '" + this.loginController.getUserPrincipal() + "'...");
                    this.loginController.doLogout(null);
                    throw new ProcessingErrorException(UserController.class.getName(), "INVALID_WORKITEM", " unable to create profile!", (Exception)e);
                }
            }
            logger.fine("profile.login.event=" + this.profileLoginEvent);
            if ((Integer)this.profileLoginEvent.get() > 0) {
                if (this.profileEvents != null) {
                    ProfileEvent event = new ProfileEvent(this.loginController.getUserPrincipal(), profile, 3);
                    this.profileEvents.fire((Object)event);
                    profile = event.getProfile();
                } else {
                    logger.warning("CDI Support is missing - ProfileEvent will not be fired");
                }
                profile.setEventID(((Integer)this.profileLoginEvent.get()).intValue());
                try {
                    profile = this.workflowService.processWorkItem(profile);
                }
                catch (EJBException | ModelException | PluginException | ProcessingErrorException e) {
                    logger.warning("Unable to process profile.login.event=" + this.profileLoginEvent + " - please check configuration!");
                }
            }
            this.setWorkitem(profile);
            this.profileLoaded = true;
            this.updateLocaleFromProfile();
            logger.info("profile '" + this.loginController.getUserPrincipal() + "' initialized.");
        }
    }

    public ItemCollection getWorkitem() throws AccessDeniedException, ProcessingErrorException {
        if (!this.profileLoaded) {
            this.init();
        }
        if (this.workitem == null) {
            this.workitem = new ItemCollection();
        }
        return this.workitem;
    }

    public void setWorkitem(ItemCollection aworkitem) {
        this.workitem = aworkitem;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            String cookieName = null;
            Cookie[] cookie = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getCookies();
            if (cookie != null && cookie.length > 0) {
                for (int i = 0; i < cookie.length; ++i) {
                    cookieName = cookie[i].getName();
                    if (!cookieName.equals(COOKIE_LOCALE)) continue;
                    String sLocale = cookie[i].getValue();
                    if (sLocale == null || "".equals(sLocale)) break;
                    StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                    if (stLocale.countTokens() == 1) {
                        String sLang = stLocale.nextToken();
                        String sCount = sLang.toUpperCase();
                        this.locale = new Locale(sLang, sCount);
                        break;
                    }
                    String sLang = stLocale.nextToken();
                    String sCount = stLocale.nextToken();
                    this.locale = new Locale(sLang, sCount);
                    break;
                }
            }
            if (this.locale == null || "".equals(this.locale.getLanguage())) {
                Locale ldefault = request.getLocale();
                this.locale = ldefault != null ? ldefault : new Locale(DEFAULT_LOCALE);
            }
        }
        return this.locale;
    }

    public void setLocale(Locale alocale) {
        this.locale = alocale == null || "".equals(alocale) ? new Locale(DEFAULT_LOCALE) : alocale;
        HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        Cookie cookieLocale = new Cookie(COOKIE_LOCALE, this.locale.toString());
        if (request.getContextPath().isEmpty()) {
            cookieLocale.setPath("/");
        } else {
            cookieLocale.setPath(request.getContextPath());
        }
        cookieLocale.setMaxAge(2592000);
        response.addCookie(cookieLocale);
    }

    public String getLanguage() {
        return this.getLocale().getLanguage();
    }

    public ItemCollection getProfile(String aAccount) {
        return this.profileService.findProfileById(aAccount);
    }

    public String getUserName(String aAccount) {
        ItemCollection profile = this.getProfile(aAccount);
        if (profile == null) {
            return null;
        }
        return profile.getItemValueString("txtuserName");
    }

    public String getEmail(String aAccount) {
        ItemCollection profile = this.getProfile(aAccount);
        if (profile == null) {
            return null;
        }
        return profile.getItemValueString("txtemail");
    }

    public void removeUserIcon() {
        String userIcon = this.workflowController.getWorkitem().getItemValueString(ITEM_USER_ICON);
        if (userIcon.isEmpty() && !"".equals(this.workflowController.getWorkitem().getItemValueString("txtusericon"))) {
            userIcon = this.workflowController.getWorkitem().getItemValueString("txtusericon");
        }
        this.workflowController.getWorkitem().removeFile(userIcon);
        this.workflowController.getWorkitem().replaceItemValue("txtusericon", (Object)"");
        this.workflowController.getWorkitem().replaceItemValue(ITEM_USER_ICON, (Object)"");
    }

    public void removeSignature() {
        String userSignature = this.workflowController.getWorkitem().getItemValueString(ITEM_SIGNATURE_IMAGE);
        this.workflowController.getWorkitem().removeFile(userSignature);
        this.workflowController.getWorkitem().replaceItemValue(ITEM_SIGNATURE_IMAGE, (Object)"");
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        String sName;
        String userID = null;
        String userIcon = null;
        String signatureImage = null;
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        String sType = workflowEvent.getWorkitem().getItemValueString("type");
        if (!sType.startsWith("profile")) {
            return;
        }
        if ("profile".equals(sType) && 22 == workflowEvent.getEventType()) {
            userID = workflowEvent.getWorkitem().getItemValueString("txtname");
            userIcon = this.getWorkitem().getItemValueString(ITEM_USER_ICON);
            if (userIcon.isEmpty() && !"".equals(this.getWorkitem().getItemValueString("txtusericon"))) {
                userIcon = this.getWorkitem().getItemValueString("txtusericon");
                this.getWorkitem().replaceItemValue(ITEM_USER_ICON, (Object)userIcon);
            }
            signatureImage = workflowEvent.getWorkitem().getItemValueString(ITEM_SIGNATURE_IMAGE);
            List fileDataList = workflowEvent.getWorkitem().getFileData();
            Collections.sort(fileDataList, new FileDataComparator());
            boolean signatureFound = false;
            boolean usericonFound = false;
            for (FileData fileData : fileDataList) {
                String filenametest = fileData.getName().toLowerCase();
                if (filenametest.startsWith("signature.") && !signatureFound) {
                    signatureFound = true;
                    if (!signatureImage.equals(fileData.getName())) {
                        signatureImage = fileData.getName();
                        workflowEvent.getWorkitem().replaceItemValue(ITEM_SIGNATURE_IMAGE, (Object)signatureImage);
                        logger.info("... '" + userID + "' new signature image upload: " + signatureImage);
                    }
                }
                if (filenametest.startsWith("signature.") || !filenametest.endsWith(".png") && !filenametest.endsWith(".gif") && !filenametest.endsWith(".jpg") || usericonFound) continue;
                usericonFound = true;
                if (userIcon.equals(fileData.getName())) continue;
                userIcon = fileData.getName();
                workflowEvent.getWorkitem().replaceItemValue(ITEM_USER_ICON, (Object)userIcon);
                logger.info("... '" + userID + "' new user icon upload: " + userIcon);
                workflowEvent.getWorkitem().replaceItemValue("txtusericon", (Object)userIcon);
            }
            ListIterator iter = fileDataList.listIterator();
            while (iter.hasNext()) {
                FileData fileData;
                fileData = (FileData)iter.next();
                String fileName = fileData.getName();
                if (fileName.startsWith("signature.") && !fileName.equals(signatureImage)) {
                    workflowEvent.getWorkitem().removeFile(fileName);
                }
                if (fileName.startsWith("signature.") || fileName.equals(userIcon)) continue;
                workflowEvent.getWorkitem().removeFile(fileName);
            }
        }
        if ("profile".equals(sType) && 23 == workflowEvent.getEventType() && (sName = workflowEvent.getWorkitem().getItemValueString("txtName")).equals(this.getWorkitem().getItemValueString("txtName"))) {
            logger.finest("......reload current user profile");
            this.setWorkitem(workflowEvent.getWorkitem());
            this.updateLocaleFromProfile();
        }
    }

    public boolean isFavorite(String id) {
        return this.getFavoriteIds().contains(id);
    }

    public List<String> getFavoriteIds() {
        if (this.getWorkitem() == null) {
            return new ArrayList<String>();
        }
        if (!this.workitem.hasItem(LINK_PROPERTY) && this.workitem.hasItem(LINK_PROPERTY_DEPRECATED)) {
            return this.workitem.getItemValue(LINK_PROPERTY_DEPRECATED);
        }
        return this.workitem.getItemValue(LINK_PROPERTY);
    }

    public void addFavorite(String id) {
        if (this.getWorkitem() == null) {
            return;
        }
        List<String> list = this.getFavoriteIds();
        if (!list.contains(id)) {
            logger.finest("......add WorkitemRef:" + id);
            list.add(id);
            this.workitem.replaceItemValue(LINK_PROPERTY, list);
            while (list.size() > 50) {
                list.remove(0);
            }
            this.workitem = this.workflowService.getDocumentService().save(this.workitem);
        }
    }

    public void removeFavorite(String id) {
        if (this.getWorkitem() == null) {
            return;
        }
        List<String> list = this.getFavoriteIds();
        if (list.contains(id)) {
            logger.finest("......remove WorkitemRef:" + id);
            list.remove(id);
            this.workitem.replaceItemValue(LINK_PROPERTY, list);
            this.workitem = this.workflowService.getDocumentService().save(this.workitem);
        }
    }

    public boolean isMobileUser() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent.indexOf("mobile") > -1;
    }

    private void updateLocaleFromProfile() throws AccessDeniedException, ProcessingErrorException {
        Locale profileLocale = null;
        String sLocale = this.getWorkitem().getItemValueString("txtLocale");
        if ("".equals(sLocale)) {
            profileLocale = this.getLocale();
            this.getWorkitem().replaceItemValue("txtLocale", (Object)profileLocale.toString());
        } else if (sLocale.indexOf(95) > -1) {
            String language = sLocale.substring(0, sLocale.indexOf(95));
            String country = sLocale.substring(sLocale.indexOf(95) + 1);
            profileLocale = new Locale(language, country);
        } else {
            profileLocale = new Locale(sLocale);
        }
        logger.fine("update user locale: " + profileLocale);
        this.setLocale(profileLocale);
        FacesContext.getCurrentInstance().getViewRoot().setLocale(profileLocale);
    }

    class FileDataComparator
    implements Comparator<FileData> {
        private final Collator collator = Collator.getInstance(Locale.getDefault());

        @Override
        public int compare(FileData a, FileData b) {
            List lb;
            Date dateA = null;
            Date dateB = null;
            List la = (List)a.getAttribute("$created");
            if (la != null && la.size() > 0) {
                dateA = (Date)la.get(0);
            }
            if ((lb = (List)b.getAttribute("$created")) != null && lb.size() > 0) {
                dateB = (Date)lb.get(0);
            }
            if (dateB == null && dateA != null) {
                return 1;
            }
            if (dateA == null && dateB != null) {
                return -1;
            }
            if (dateA == null && dateB == null) {
                return 0;
            }
            int result = dateA.compareTo(dateB);
            return result;
        }
    }
}

