/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.profile;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.profile.UserController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.index.SchemaService;

@Named(value="userInputController")
@RequestScoped
public class UserInputController
implements Serializable {
    @Inject
    protected UserController userController;
    @EJB
    protected WorkflowService workflowService;
    @EJB
    protected SchemaService schemaService;
    @EJB
    protected ProfileService profileService;
    private List<ItemCollection> searchResult = new ArrayList<ItemCollection>();
    private static int MAX_SEARCH_RESULT = 100;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UserInputController.class.getName());

    public List<ItemCollection> searchProfile(String phrase) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            phrase = phrase.trim().toLowerCase();
            phrase = this.schemaService.escapeSearchTerm(phrase);
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            String sQuery = "(type:profile) AND ($processid:[210 TO 249]) AND " + phrase + "*";
            logger.finest("searchprofile: " + sQuery);
            logger.fine("searchWorkitems: " + sQuery);
            col = this.workflowService.getDocumentService().find(sQuery, MAX_SEARCH_RESULT, 0);
        }
        catch (Exception e) {
            logger.warning("Lucene error error: " + e.getMessage());
        }
        if (col != null) {
            for (ItemCollection profile : col) {
                searchResult.add(this.profileService.cloneWorkitem(profile));
            }
            Collections.sort(searchResult, new ItemCollectionComparator("txtusername", true));
        }
        return searchResult;
    }

    public List<ItemCollection> getSearchResult() {
        return this.searchResult;
    }

    public boolean isRole(String aName) {
        String accessRoles = this.workflowService.getDocumentService().getAccessRoles();
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS,org.imixs.ACCESSLEVEL.MANAGERACCESS," + accessRoles;
        List<String> roles = Arrays.asList(roleList.split("\\s*,\\s*"));
        return roles.stream().anyMatch(aName::equalsIgnoreCase);
    }

    public List<ItemCollection> getSortedProfilelist(List<Object> aNameList) {
        ArrayList<ItemCollection> profiles = new ArrayList<ItemCollection>();
        if (aNameList == null) {
            return profiles;
        }
        for (Object aentry : aNameList) {
            if (aentry == null || aentry.toString().isEmpty()) continue;
            ItemCollection profile = this.userController.getProfile(aentry.toString());
            if (profile != null) {
                profiles.add(profile);
                continue;
            }
            profile = new ItemCollection();
            profile.replaceItemValue("txtName", (Object)aentry.toString());
            profile.replaceItemValue("txtUserName", (Object)aentry.toString());
            profiles.add(profile);
        }
        Collections.sort(profiles, new ItemCollectionComparator("txtUserName", true));
        return profiles;
    }

    public List<?> uniqueList(List<Object> valueList) {
        int iVectorSize = valueList.size();
        Vector<Object> cleanedVector = new Vector<Object>();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = valueList.get(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        valueList = cleanedVector;
        if (valueList.size() == 0) {
            valueList.add("");
        }
        return valueList;
    }

    public void searchUser() {
        this.searchResult = new ArrayList<ItemCollection>();
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        if (phrase == null) {
            return;
        }
        logger.finest("......user search prase '" + phrase + "'");
        this.searchResult = this.searchProfile(phrase);
        if (this.searchResult != null) {
            logger.finest("found " + this.searchResult.size() + " user profiles...");
        }
    }

    public String getUserName(String userid) {
        ItemCollection profile = this.userController.getProfile(userid);
        if (profile != null) {
            return profile.getItemValueString("txtusername");
        }
        return userid;
    }
}

