/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.rest;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.team.TeamService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;

@Named
@RequestScoped
@Path(value="/team")
@Produces(value={"text/html", "application/xml", "application/json"})
public class TeamRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TeamRestService.class.getSimpleName());
    @EJB
    DocumentService entityService;
    @EJB
    ModelService modelService;
    @EJB
    TeamService teamService;

    @GET
    @Path(value="/processlist")
    public XMLDataCollection getProcessList() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getProcessList();
            logger.fine("getProcessList - " + col.size() + " entries found");
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/processlist.xml")
    @Produces(value={"text/xml"})
    public XMLDataCollection getProcessListXML() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getProcessList();
            logger.fine("getProcessList - " + col.size() + " entries found");
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/processlist.json")
    @Produces(value={"application/json"})
    public XMLDataCollection getProcessListJSON() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getProcessList();
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/spaces")
    public XMLDataCollection getSpaces() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getSpaces();
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/spaces.xml")
    @Produces(value={"text/xml"})
    public XMLDataCollection getSpacesXML() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getSpaces();
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/spaces.json")
    @Produces(value={"application/json"})
    public XMLDataCollection getSpacesJSON() {
        List<ItemCollection> col = null;
        try {
            col = this.teamService.getProcessList();
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/workflowgroups.json")
    @Produces(value={"application/json"})
    public XMLDataCollection getWorkflowGroupsJSON() throws ModelException {
        ArrayList<ItemCollection> col = new ArrayList<ItemCollection>();
        ArrayList<String> result = new ArrayList<String>();
        List modelVersions = this.modelService.getVersions();
        for (String modelVersion : modelVersions) {
            if (modelVersion.startsWith("system")) continue;
            List groups = this.modelService.getModel(modelVersion).getGroups();
            for (String group : groups) {
                if (result.contains(group)) continue;
                result.add(group);
                ItemCollection itemCol = new ItemCollection();
                itemCol.replaceItemValue("$WorkflowGroup", (Object)group);
                itemCol.replaceItemValue("txtName", (Object)group);
                col.add(itemCol);
            }
        }
        try {
            return XMLDataCollectionAdapter.getDataCollection(col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }
}

