/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.rest;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;

@Named(value="userService")
@RequestScoped
@Path(value="/user")
@Produces(value={"text/html", "application/xml", "application/json"})
public class UserRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UserRestService.class.getSimpleName());
    @EJB
    DocumentService documentService;
    @EJB
    ProfileService profileService;

    @GET
    @Path(value="/favorites")
    public XMLDataCollection getFavorites(@Context HttpServletRequest servletRequest) {
        List col = null;
        try {
            List<String> favorites = this.getFavoriteIds(servletRequest);
            if (favorites.size() <= 0) {
                return new XMLDataCollection();
            }
            Object inStatement = "(";
            for (String aID : favorites) {
                inStatement = (String)inStatement + "\"$uniqueid:" + aID + "\" OR ";
            }
            inStatement = ((String)inStatement).substring(0, ((String)inStatement).length() - 3) + ")";
            String sQuery = "( (type:\"workitem\" OR type:\"workitem\") AND " + (String)inStatement + ")";
            col = this.documentService.find(sQuery, 0, -1);
            return XMLDataCollectionAdapter.getDataCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/favorites.xml")
    @Produces(value={"text/xml"})
    public XMLDataCollection getFavoritesXML(@Context HttpServletRequest servletRequest) {
        try {
            return this.getFavorites(servletRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/favorites.json")
    @Produces(value={"application/json"})
    public XMLDataCollection getFavoritesJSON(@Context HttpServletRequest servletRequest) {
        try {
            return this.getFavorites(servletRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    private List<String> getFavoriteIds(HttpServletRequest servletRequest) {
        ItemCollection profile = null;
        Principal user = servletRequest.getUserPrincipal();
        String userid = null;
        if (user != null) {
            userid = user.getName();
        }
        String sQuery = "(type:\"profile\" AND txtname:\"" + userid + "\")";
        try {
            List col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                profile = (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning("getFavoriteIds - invalid query: " + e.getMessage());
        }
        if (profile == null) {
            return new ArrayList<String>();
        }
        return profile.getItemValue("$WorkitemRef");
    }
}

