/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.security;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.security.UserGroupService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.SetupEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Path(value="/setup")
@Singleton
public class SetupUserDBService {
    public static String USERDB_OK = "USERDB_OK";
    public static String USERDB_DISABLED = "USERDB_DISABLED";
    @EJB
    private UserGroupService userGroupService;
    @EJB
    private ModelService modelService;
    @Inject
    @ConfigProperty(name="security.setup.mode", defaultValue="auto")
    String setupMode;
    private static Logger logger = Logger.getLogger(SetupUserDBService.class.getName());

    public void onSetupEvent(@Observes SetupEvent setupEvent) throws AccessDeniedException {
        this.init();
    }

    @GET
    public String init() {
        String result;
        block5: {
            result = "";
            logger.info("...starting UserDB Setup...");
            logger.info("...setup.mode = " + this.setupMode);
            if ("auto".equalsIgnoreCase(this.setupMode)) {
                try {
                    if (this.userGroupService != null) {
                        this.userGroupService.initUserIDs();
                        logger.info("...UserDB OK");
                        result = USERDB_OK;
                        break block5;
                    }
                    logger.warning("userGroupService not initialized!");
                }
                catch (Exception e) {
                    logger.warning("Error during initializing UserDB: " + e.getMessage());
                }
            } else {
                result = USERDB_DISABLED;
                logger.finest("......UserDB is disabled.");
            }
        }
        logger.info("...SystemSetup: " + result);
        return result;
    }
}

