/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.security;

import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.security.UserGroupService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class UserGroupPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    static final int EVENT_PROFILE_LOCK = 90;
    static final int TASK_PPROFILE_ACTIVE = 210;
    @EJB
    DocumentService documentService;
    @EJB
    UserGroupService userGroupService = null;
    @Inject
    @ConfigProperty(name="security.setup.mode", defaultValue="auto")
    String setupMode;
    int sequenceNumber = -1;
    ItemCollection workitem = null;
    private static Logger logger = Logger.getLogger(UserGroupPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        if (this.userGroupService == null) {
            return documentContext;
        }
        this.workitem = documentContext;
        String sType = this.workitem.getItemValueString("Type");
        if (!"profile".equals(sType)) {
            return documentContext;
        }
        if (!"auto".equalsIgnoreCase(this.setupMode)) {
            return documentContext;
        }
        int iProcessID = this.workitem.getItemValueInteger("$ProcessID");
        int iActivityID = documentActivity.getItemValueInteger("numActivityID");
        if (!"admin".equalsIgnoreCase(this.workitem.getItemValueString("txtname")) && iProcessID >= 210 && iActivityID == 90) {
            logger.info("Lock profile '" + this.workitem.getItemValueString("txtname") + "'");
            this.workitem.replaceItemValue("txtGroups", (Object)UserGroupService.ACCESSLEVEL_NOACCESS);
        }
        logger.fine("......update profile '" + this.workitem.getItemValueString("txtname") + "'....");
        this.migrateDeprecatedUserRoles();
        this.userGroupService.updateUser(this.workitem);
        return documentContext;
    }

    private void migrateDeprecatedUserRoles() {
        ArrayList clonedGoupNames = new ArrayList();
        clonedGoupNames.addAll(this.workitem.getItemValue("txtGroups"));
        List<String> deprecatedCoreGrouplist = Arrays.asList(UserGroupService.DEPRECATED_CORE_GROUPS);
        for (String aGroup : clonedGoupNames) {
            if (!deprecatedCoreGrouplist.contains(aGroup) || clonedGoupNames.contains(this.userGroupService.getCoreGroupName(aGroup))) continue;
            String newGroup = this.userGroupService.getCoreGroupName(aGroup);
            logger.warning("...Your Application provides deprecated userroles! This should not happen - check your application!!");
            logger.warning("..." + this.workitem.getItemValueString("txtname") + " contains depreacted userrole " + aGroup);
            logger.warning("... Group will be automatically migrated to " + newGroup);
            this.workitem.appendItemValueUnique("txtGroups", (Object)newGroup);
        }
    }
}

