/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.security;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.security.Crypter;
import org.imixs.marty.security.UserGroup;
import org.imixs.marty.security.UserId;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class UserGroupService {
    public static String ACCESSLEVEL_NOACCESS = "org.imixs.ACCESSLEVEL.NOACCESS";
    public static String DEFAULT_ACCOUNT = "admin";
    public static String DEFAULT_PASSWORD = "adminadmin";
    public static final String[] CORE_GROUPS = new String[]{"org.imixs.ACCESSLEVEL.MANAGERACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.READERACCESS"};
    public static final String[] DEPRECATED_CORE_GROUPS = new String[]{"IMIXS-WORKFLOW-Manager", "IMIXS-WORKFLOW-Editor", "IMIXS-WORKFLOW-Author", "IMIXS-WORKFLOW-Reader"};
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Resource
    SessionContext ctx;
    @EJB
    DocumentService documentService;
    @Inject
    @ConfigProperty(name="security.userid.input.mode", defaultValue="LOWERCASE")
    String userInputMode;
    private static Logger logger = Logger.getLogger(UserGroupService.class.getName());

    public void updateUser(ItemCollection profile) {
        boolean debug = logger.isLoggable(Level.FINE);
        String sType = profile.getItemValueString("Type");
        if (!"profile".equals(sType)) {
            return;
        }
        String sID = profile.getItemValueString("txtName");
        String sPassword = profile.getItemValueString("txtPassword");
        List groups = profile.getItemValue("txtGroups");
        UserId user = null;
        user = (UserId)this.manager.find(UserId.class, (Object)sID);
        if (user == null) {
            user = new UserId(sID);
            this.manager.persist((Object)user);
        }
        if (sPassword != null && !"".equals(sPassword)) {
            String sEncryptedPasswort = Crypter.crypt(sPassword);
            user.setPassword(sEncryptedPasswort);
            profile.removeItem("txtPassword");
            profile.removeItem("txtpassword2");
            logger.info("password change for userid '" + sID + "' by '" + this.ctx.getCallerPrincipal().getName() + "'");
            profile.replaceItemValue("txtpasswordhash", (Object)sEncryptedPasswort);
        }
        if (user.getPassword() == null || user.getPassword().isEmpty()) {
            user.setPassword(Crypter.crypt(WorkflowKernel.generateUniqueID()));
        }
        HashSet<UserGroup> groupList = new HashSet<UserGroup>();
        for (String aGroup : groups) {
            if (aGroup == null || aGroup.isEmpty()) continue;
            UserGroup group = (UserGroup)this.manager.find(UserGroup.class, (Object)aGroup);
            if (group == null) {
                group = new UserGroup(aGroup);
                this.manager.persist((Object)group);
            }
            groupList.add(group);
        }
        if (groupList.size() == 0) {
            UserGroup noAccessGroup = (UserGroup)this.manager.find(UserGroup.class, (Object)ACCESSLEVEL_NOACCESS);
            if (noAccessGroup == null) {
                noAccessGroup = new UserGroup(ACCESSLEVEL_NOACCESS);
                this.manager.persist((Object)noAccessGroup);
            }
            groupList.add(noAccessGroup);
        }
        user.setUserGroups(groupList);
        if (debug) {
            logger.fine("...update '" + sID + "'  Groups: ");
            groups.forEach(n -> logger.fine("...       '" + n + "'"));
        }
    }

    public void changeUserId(String oldID, String newID) {
        UserId user = null;
        user = (UserId)this.manager.find(UserId.class, (Object)newID);
        if (user != null) {
            logger.warning("changeUser - new userId '" + newID + "'is still in Use!");
            return;
        }
        user = (UserId)this.manager.find(UserId.class, (Object)oldID);
        if (user == null) {
            logger.warning("changeUser - UserID '" + oldID + "' not found!");
            return;
        }
        UserId newUser = new UserId(newID);
        newUser.setPassword(user.getPassword());
        newUser.setUserGroups(user.getUserGroups());
        this.manager.persist((Object)newUser);
        this.manager.remove((Object)user);
        logger.info("changeUserId '" + oldID + "' to '" + newID + "' by '" + this.ctx.getCallerPrincipal().getName());
    }

    public void removeUserId(String userID) {
        UserId user = null;
        user = (UserId)this.manager.find(UserId.class, (Object)userID);
        if (user == null) {
            logger.warning("removeUserId - userId '" + userID + "' did not exist!");
            return;
        }
        this.manager.remove((Object)user);
        logger.info("removeUserId '" + userID + "' by '" + this.ctx.getCallerPrincipal().getName());
    }

    public void initUserIDs() {
        logger.finest("......init UserIDs...");
        this.verifyExistingProfileData();
        this.migrateDeprecatedUserRoles();
        String sAdminAccount = DEFAULT_ACCOUNT;
        if ("uppercase".equalsIgnoreCase(this.userInputMode)) {
            sAdminAccount = sAdminAccount.toUpperCase();
        }
        String sQuery = "SELECT user FROM UserId AS user WHERE user.id='" + sAdminAccount + "'";
        Query q = this.manager.createQuery(sQuery);
        q.setFirstResult(0);
        q.setMaxResults(1);
        List entityList = q.getResultList();
        if (entityList == null || entityList.size() == 0) {
            logger.info("Create default admin account...");
            ItemCollection profile = new ItemCollection();
            profile.replaceItemValue("type", (Object)"profile");
            profile.replaceItemValue("txtName", (Object)sAdminAccount);
            profile.replaceItemValue("txtPassword", (Object)DEFAULT_PASSWORD);
            profile.replaceItemValue("$WorkflowGroup", (Object)"Profile");
            profile.replaceItemValue("txtGroups", (Object)"IMIXS-WORKFLOW-Manager");
            profile.appendItemValue("txtGroups", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
            profile.replaceItemValue("$modelversion", (Object)"system-de-0.0.1");
            profile.replaceItemValue("$workflowgroup", (Object)"Profil");
            profile.replaceItemValue("$processid", (Object)210);
            try {
                this.updateUser(profile);
                this.documentService.save(profile);
            }
            catch (AccessDeniedException e) {
                logger.warning("UserGroupService - unable to initialize default admin account");
                logger.severe(e.getMessage());
                return;
            }
        }
    }

    public void migrateDeprecatedUserRoles() {
        UserGroup group;
        boolean needMigration = false;
        for (String aGroup : CORE_GROUPS) {
            group = (UserGroup)this.manager.find(UserGroup.class, (Object)aGroup);
            if (group != null) continue;
            needMigration = true;
            break;
        }
        if (!needMigration) {
            logger.info("...Imixs core userGroups OK...");
            return;
        }
        logger.info("*************************************************");
        logger.info("...System contains deprecated userGroups!");
        logger.info("...migration to new Imixs core user groups starting....");
        logger.info("*************************************************");
        for (String aGroup : CORE_GROUPS) {
            group = (UserGroup)this.manager.find(UserGroup.class, (Object)aGroup);
            if (group != null) continue;
            group = new UserGroup(aGroup);
            this.manager.persist((Object)group);
        }
        this.migrateExistingProfileData();
        logger.info("*************************************************");
        logger.info("...migration to new Imixs core user groups finished successful.");
        logger.info("*************************************************");
    }

    private void verifyExistingProfileData() {
        logger.info("...verify existing profile data...");
        List profiles = this.documentService.getDocumentsByType("profile");
        for (ItemCollection profile : profiles) {
            String passwordhash;
            String id = profile.getItemValueString("txtname");
            UserId user = null;
            user = (UserId)this.manager.find(UserId.class, (Object)id);
            if (user != null || (passwordhash = profile.getItemValueString("txtpasswordhash")).isEmpty()) continue;
            logger.info("...restore userid '" + id + "' from existing profile data...");
            user = new UserId(id);
            user.setPassword(passwordhash);
            this.manager.persist((Object)user);
            List groups = profile.getItemValue("txtGroups");
            HashSet<UserGroup> groupList = new HashSet<UserGroup>();
            for (String aGroup : groups) {
                if (aGroup == null || aGroup.isEmpty()) continue;
                UserGroup group = (UserGroup)this.manager.find(UserGroup.class, (Object)aGroup);
                if (group == null) {
                    group = new UserGroup(aGroup);
                    this.manager.persist((Object)group);
                }
                groupList.add(group);
            }
            if (groupList.size() == 0) {
                UserGroup noAccessGroup = (UserGroup)this.manager.find(UserGroup.class, (Object)ACCESSLEVEL_NOACCESS);
                if (noAccessGroup == null) {
                    noAccessGroup = new UserGroup(ACCESSLEVEL_NOACCESS);
                    this.manager.persist((Object)noAccessGroup);
                }
                groupList.add(noAccessGroup);
            }
            user.setUserGroups(groupList);
        }
    }

    private void migrateExistingProfileData() {
        int count = 0;
        List<String> deprecatedCoreGrouplist = Arrays.asList(DEPRECATED_CORE_GROUPS);
        logger.info("migrate deprecated profile data...");
        List profiles = this.documentService.getDocumentsByType("profile");
        for (ItemCollection profile : profiles) {
            String id = profile.getItemValueString("txtname");
            UserId user = null;
            user = (UserId)this.manager.find(UserId.class, (Object)id);
            if (user == null) continue;
            logger.info("...migate deprecated userroles for '" + id + "' ...");
            List groupNames = profile.getItemValue("txtGroups");
            ArrayList<String> newGroupNames = new ArrayList<String>();
            newGroupNames.addAll(groupNames);
            for (String aGroup : groupNames) {
                if (!deprecatedCoreGrouplist.contains(aGroup) || groupNames.contains(this.getCoreGroupName(aGroup))) continue;
                String newGroup = this.getCoreGroupName(aGroup);
                logger.info("..." + id + " contains depreacted userrole " + aGroup);
                logger.info("... Group will be automatically migrated to " + newGroup);
                newGroupNames.add(newGroup);
            }
            logger.info("...Updating UserGroup objects....");
            HashSet<UserGroup> groupList = new HashSet<UserGroup>();
            for (String aGroup : newGroupNames) {
                if (aGroup == null || aGroup.isEmpty()) continue;
                UserGroup group = (UserGroup)this.manager.find(UserGroup.class, (Object)aGroup);
                if (group == null) {
                    group = new UserGroup(aGroup);
                    this.manager.persist((Object)group);
                }
                groupList.add(group);
            }
            user.setUserGroups(groupList);
            if (user.getPassword() == null || user.getPassword().isEmpty()) {
                logger.info("..." + id + " contains empty password - set random password...");
                user.setPassword(Crypter.crypt(WorkflowKernel.generateUniqueID()));
            }
            if (newGroupNames.size() == groupNames.size()) continue;
            profile.setItemValue("txtGroups", newGroupNames);
            this.documentService.save(profile);
            ++count;
        }
        logger.info("... " + count + " user profiles updated....");
    }

    public String getDeprecatedGroupName(String newGroupName) {
        List<String> grouplist = Arrays.asList(CORE_GROUPS);
        int pos = grouplist.indexOf(newGroupName);
        if (pos >= 0) {
            return DEPRECATED_CORE_GROUPS[pos];
        }
        return null;
    }

    public String getCoreGroupName(String deprecatedGroupName) {
        List<String> grouplist = Arrays.asList(DEPRECATED_CORE_GROUPS);
        int pos = grouplist.indexOf(deprecatedGroupName);
        if (pos >= 0) {
            return CORE_GROUPS[pos];
        }
        return null;
    }
}

