/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.ejb.EJB;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.team.SpaceService;
import org.imixs.marty.team.TeamCache;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

public class SpacePlugin
extends AbstractPlugin {
    public static String SPACE_DELETE_ERROR = "SPACE_DELETE_ERROR";
    public static String SPACE_ARCHIVE_ERROR = "SPACE_ARCHIVE_ERROR";
    public static String ORGUNIT_NAME_ERROR = "ORGUNIT_NAME_ERROR";
    private static Logger logger = Logger.getLogger(SpacePlugin.class.getName());
    private ItemCollection space = null;
    @EJB
    TeamCache teamCache;
    @EJB
    SpaceService spaceService;

    public ItemCollection run(ItemCollection documentContext, ItemCollection event) throws PluginException {
        List<ItemCollection> subspaces;
        this.space = null;
        String type = documentContext.getType();
        if ("spacedeleted".equals(type)) {
            List<ItemCollection> subspaces2 = this.spaceService.findAllSubSpaces(documentContext.getUniqueID(), "space", "spacearchive");
            if (subspaces2 != null && subspaces2.size() > 0) {
                throw new PluginException(SpacePlugin.class.getName(), SPACE_DELETE_ERROR, "Space object can not be deleted, because descendant space object(s) exist!");
            }
            return documentContext;
        }
        if ("spacearchive".equals(type) && (subspaces = this.spaceService.findAllSubSpaces(documentContext.getUniqueID(), "space")) != null && subspaces.size() > 0) {
            throw new PluginException(SpacePlugin.class.getName(), SPACE_ARCHIVE_ERROR, "Space object can not be archived, because active descendant space object(s) exist!");
        }
        if ("space".equals(type) || "spacearchive".equals(type)) {
            this.space = documentContext;
            this.inheritParentSpaceProperties();
            this.validateUniqueOrgunitName(this.space, "space");
            this.spaceService.updateSubSpaces(this.space);
        }
        if ("process".equals(type)) {
            this.validateUniqueOrgunitName(documentContext, "process");
        }
        return documentContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void inheritParentSpaceProperties() throws PluginException {
        ItemCollection parentProject = null;
        String sParentProjectID = this.space.getItemValueString("$uniqueidRef");
        if (!sParentProjectID.isEmpty()) {
            parentProject = this.getWorkflowService().getDocumentService().load(sParentProjectID);
        }
        if (parentProject != null) {
            if (!"space".equals(parentProject.getType())) throw new PluginException(SpacePlugin.class.getName(), SPACE_ARCHIVE_ERROR, "Space object can not be updated, because parent space object is archived!");
            logger.fine("Updating Parent Project Informations for '" + sParentProjectID + "'");
            String sName = this.space.getItemValueString("space.name");
            String sParentName = parentProject.getItemValueString("name");
            this.space.replaceItemValue("name", (Object)(sParentName + "." + sName));
            this.space.replaceItemValue("space.parent.name", (Object)sParentName);
            return;
        } else {
            this.space.replaceItemValue("name", (Object)this.space.getItemValueString("space.name"));
        }
    }

    private void validateUniqueOrgunitName(ItemCollection orgunit, String type) throws PluginException {
        String name = orgunit.getItemValueString("name");
        String unqiueid = orgunit.getUniqueID();
        String sQuery = "((type:\"" + type + "\" OR type:\"" + type + "archive\") AND (txtname:\"" + name + "\" OR name:\"" + name + "\"))";
        try {
            List spaceList = this.getWorkflowService().getDocumentService().find(sQuery, 9999, 0);
            for (ItemCollection aspace : spaceList) {
                if (aspace.getUniqueID().equals(unqiueid)) continue;
                throw new PluginException(SpacePlugin.class.getName(), ORGUNIT_NAME_ERROR, type + " with this name already exists!");
            }
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
    }
}

