/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SpaceService {
    private static Logger logger = Logger.getLogger(SpaceService.class.getName());
    @EJB
    DocumentService documentService;

    public void updateSubSpaces(ItemCollection parentSpace) {
        logger.finest("......updating sub-space data for '" + parentSpace.getItemValueString("$Uniqueid") + "'");
        List<ItemCollection> subSpaceList = this.findAllSubSpaces(parentSpace.getItemValueString("$Uniqueid"), "space", "spacearchive");
        String sParentSpaceName = parentSpace.getItemValueString("name");
        for (ItemCollection aSubSpace : subSpaceList) {
            aSubSpace.replaceItemValue("space.parent.name", (Object)sParentSpaceName);
            aSubSpace.replaceItemValue("name", (Object)(sParentSpaceName + "." + aSubSpace.getItemValueString("space.name")));
            aSubSpace.replaceItemValue("txtparentname", (Object)sParentSpaceName);
            aSubSpace = this.documentService.save(aSubSpace);
            this.updateSubSpaces(aSubSpace);
        }
    }

    public List<ItemCollection> findAllSubSpaces(String sIDRef, String ... types) {
        List subSpaceList;
        if (sIDRef == null) {
            return null;
        }
        Object sQuery = "(";
        if (types != null && types.length > 0) {
            sQuery = (String)sQuery + "(";
            for (int i = 0; i < types.length; ++i) {
                sQuery = (String)sQuery + " type:\"" + types[i] + "\"";
                if (i + 1 >= types.length) continue;
                sQuery = (String)sQuery + " OR ";
            }
            sQuery = (String)sQuery + ") ";
        }
        sQuery = (String)sQuery + " AND $uniqueidref:\"" + sIDRef + "\")";
        try {
            subSpaceList = this.documentService.find((String)sQuery, 9999, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        Collections.sort(subSpaceList, new ItemCollectionComparator("txtname", true));
        return subSpaceList;
    }
}

