/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.Singleton;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class TeamCache {
    int DEFAULT_CACHE_SIZE = 500;
    int DEFAULT_EXPIRES_TIME = 3600000;
    long expiresTime = 0L;
    long lastReset = 0L;
    private Properties configurationProperties = null;
    private Cache cache = null;
    private static Logger logger = Logger.getLogger(TeamCache.class.getName());

    @PostConstruct
    void init() {
        try {
            this.configurationProperties = new Properties();
            try {
                this.configurationProperties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
            }
            catch (Exception e) {
                logger.warning("unable to find imixs.properties in current classpath");
                e.printStackTrace();
            }
            this.resetCache();
        }
        catch (Exception e) {
            logger.severe("unable to initalize cache");
            e.printStackTrace();
        }
    }

    public void resetCache() {
        logger.finest("......resetCache....");
        int iCacheSize = this.DEFAULT_CACHE_SIZE;
        try {
            iCacheSize = Integer.valueOf(this.configurationProperties.getProperty("team.cache-size", "" + this.DEFAULT_CACHE_SIZE));
        }
        catch (NumberFormatException nfe) {
            iCacheSize = this.DEFAULT_CACHE_SIZE;
        }
        if (iCacheSize <= 0) {
            iCacheSize = this.DEFAULT_CACHE_SIZE;
        }
        logger.finest("......resetCache - cache size = " + iCacheSize);
        this.cache = new Cache(iCacheSize);
        try {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
            String sExpires = this.configurationProperties.getProperty("team.cache-expires", "" + this.DEFAULT_EXPIRES_TIME);
            this.expiresTime = Long.valueOf(sExpires);
        }
        catch (NumberFormatException nfe) {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
        }
        if (this.expiresTime <= 0L) {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
        }
        logger.finest("......resetCache - cache expires after = " + this.expiresTime + "ms");
        this.lastReset = System.currentTimeMillis();
    }

    public Object get(String key) {
        Long now;
        if (this.expiresTime > 0L && (now = Long.valueOf(System.currentTimeMillis())) - this.lastReset > this.expiresTime) {
            logger.finest("......cache expired!");
            this.resetCache();
        }
        return this.cache.get(key);
    }

    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    public void put(String key, Object value) {
        this.cache.put(key, value);
    }

    class Cache
    extends ConcurrentHashMap<String, Object>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public Cache(int capacity) {
            super(capacity + 1, 1.1f);
            this.capacity = capacity;
        }

        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > this.capacity;
        }
    }
}

