/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.team.TeamService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.faces.util.ResourceBundleHandler;

@Named
@SessionScoped
public class TeamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> spaces = null;
    private List<ItemCollection> processList = null;
    private ItemCollection process = null;
    @Inject
    protected LoginController loginController = null;
    @Inject
    protected ResourceBundleHandler resourceBundleHandler = null;
    @EJB
    protected DocumentService documentService;
    @EJB
    protected TeamService teamService;
    @EJB
    protected ProfileService profileService;
    private static Logger logger = Logger.getLogger(TeamController.class.getName());

    @PostConstruct
    public void reset() {
        this.spaces = null;
        this.processList = null;
        this.process = null;
    }

    public ItemCollection getProcess() {
        return this.process;
    }

    public void setProcess(ItemCollection process) {
        this.process = process;
    }

    public ItemCollection loadProcess(String uniqueid) {
        if (this.process == null || !this.process.getItemValue("$uniqueid").equals(uniqueid)) {
            this.setProcess(this.getProcessById(uniqueid));
        }
        return this.getProcess();
    }

    public ItemCollection getProcessById(String uniqueId) {
        if (uniqueId != null && !uniqueId.isEmpty()) {
            List<ItemCollection> list = this.getProcessList();
            for (ItemCollection process : list) {
                if (!uniqueId.equals(process.getItemValueString("$uniqueid"))) continue;
                return process;
            }
        }
        return null;
    }

    public List<ItemCollection> getProcessList() {
        if (this.processList == null) {
            this.processList = this.teamService.getProcessList();
        }
        return this.processList;
    }

    public List<ItemCollection> getSpaces() {
        if (this.spaces == null) {
            this.spaces = this.teamService.getSpaces();
        }
        return this.spaces;
    }

    public ItemCollection getEntityById(String uniqueid) {
        if (uniqueid == null || uniqueid.isEmpty()) {
            return null;
        }
        List<ItemCollection> alist = this.getProcessList();
        for (ItemCollection aProcess : alist) {
            if (!uniqueid.equals(aProcess.getUniqueID())) continue;
            return aProcess;
        }
        alist = this.getSpaces();
        for (ItemCollection aSpace : alist) {
            if (!uniqueid.equals(aSpace.getUniqueID())) continue;
            return aSpace;
        }
        return null;
    }

    public ItemCollection getSpaceById(String uniqueId) {
        if (uniqueId != null && !uniqueId.isEmpty()) {
            List<ItemCollection> list = this.getSpaces();
            for (ItemCollection space : list) {
                if (!uniqueId.equals(space.getItemValueString("$uniqueid"))) continue;
                return space;
            }
        }
        return null;
    }

    public ItemCollection getProcessByName(String name) {
        if (name != null && !name.isEmpty()) {
            List<ItemCollection> list = this.getProcessList();
            for (ItemCollection process : list) {
                if (!name.equals(process.getItemValueString("name")) && !name.equals(process.getItemValueString("txtName"))) continue;
                return process;
            }
        }
        return null;
    }

    public ItemCollection getSpaceByName(String name) {
        if (name != null && !name.isEmpty()) {
            List<ItemCollection> list = this.getSpaces();
            for (ItemCollection space : list) {
                if (!name.equals(space.getItemValueString("name")) && !name.equals(space.getItemValueString("txtName"))) continue;
                return space;
            }
        }
        return null;
    }

    public List<ItemCollection> getSpacesByProcessId(String uniqueId) {
        List<ItemCollection> result = new ArrayList<ItemCollection>();
        if (uniqueId != null && !uniqueId.isEmpty()) {
            ItemCollection process = this.getProcessById(uniqueId);
            result = this.getSpacesByProcess(process);
        }
        return result;
    }

    public List<ItemCollection> getSpacesByProcess(ItemCollection process) {
        List refs;
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (process != null && (refs = process.getItemValue("$uniqueidref")) != null && !refs.isEmpty()) {
            List<ItemCollection> list = this.getSpaces();
            for (ItemCollection space : list) {
                if (!refs.contains(space.getItemValueString("$uniqueid"))) continue;
                result.add(space);
            }
        }
        return result;
    }

    public List<ItemCollection> getSpacesByRef(String uniqueId) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (uniqueId != null && !uniqueId.isEmpty()) {
            List<ItemCollection> list = this.getSpaces();
            for (ItemCollection space : list) {
                logger.fine("Spacename= " + space.getItemValueString("Name") + " uniquidref= " + space.getItemValueString("$uniqueidref"));
                if (!uniqueId.equals(space.getItemValueString("$uniqueidref"))) continue;
                result.add(space);
            }
        }
        return result;
    }

    public List<ItemCollection> getRootSpaces() {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List<ItemCollection> list = this.getSpaces();
        for (ItemCollection space : list) {
            logger.fine("Spacename= " + space.getItemValueString("txtName") + " uniquidref= " + space.getItemValueString("$uniqueidref"));
            if (!space.getItemValueString("$uniqueidref").isEmpty()) continue;
            result.add(space);
        }
        return result;
    }

    public List<ItemCollection> getManagers(String aUniqueID) {
        List<ItemCollection> resultList = this.getMemberListByRole(aUniqueID, "manager");
        Collections.sort(resultList, new ItemCollectionComparator("txtUserName", true));
        return resultList;
    }

    public List<ItemCollection> getTeam(String aUniqueID) {
        List<ItemCollection> resultList = this.getMemberListByRole(aUniqueID, "team");
        Collections.sort(resultList, new ItemCollectionComparator("txtUserName", true));
        return resultList;
    }

    public List<ItemCollection> getAssist(String aUniqueID) {
        List<ItemCollection> resultList = this.getMemberListByRole(aUniqueID, "assist");
        Collections.sort(resultList, new ItemCollectionComparator("txtUserName", true));
        return resultList;
    }

    public List<ItemCollection> getProcessMembers(String aUniqueID) {
        ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
        ArrayList<String> dupplicatedIds = new ArrayList<String>();
        List<ItemCollection> assistList = this.getMemberListByRole(aUniqueID, "assist");
        List<ItemCollection> teamList = this.getMemberListByRole(aUniqueID, "team");
        List<ItemCollection> managerList = this.getMemberListByRole(aUniqueID, "manager");
        for (ItemCollection profile : teamList) {
            if (!dupplicatedIds.contains(profile.getItemValueString("$uniqueid"))) {
                resultList.add(profile);
            }
            dupplicatedIds.add(profile.getItemValueString("$uniqueid"));
        }
        for (ItemCollection profile : managerList) {
            if (!dupplicatedIds.contains(profile.getItemValueString("$uniqueid"))) {
                resultList.add(profile);
            }
            dupplicatedIds.add(profile.getItemValueString("$uniqueid"));
        }
        for (ItemCollection profile : assistList) {
            if (!dupplicatedIds.contains(profile.getItemValueString("$uniqueid"))) {
                resultList.add(profile);
            }
            dupplicatedIds.add(profile.getItemValueString("$uniqueid"));
        }
        Collections.sort(resultList, new ItemCollectionComparator("txtUserName", true));
        return resultList;
    }

    public boolean isManagerOf(String aUniqueID) {
        ItemCollection entity = this.getEntityById(aUniqueID);
        if (entity != null) {
            return entity.getItemValueBoolean("isManager");
        }
        return false;
    }

    public boolean isTeamMemberOf(String aUniqueID) {
        ItemCollection entity = this.getEntityById(aUniqueID);
        if (entity != null) {
            return entity.getItemValueBoolean("isTeam");
        }
        return false;
    }

    public boolean isAssistOf(String aUniqueID) {
        ItemCollection entity = this.getEntityById(aUniqueID);
        if (entity != null) {
            return entity.getItemValueBoolean("isAssist");
        }
        return false;
    }

    public boolean isMemberOf(String aUniqueID) {
        ItemCollection entity = this.getEntityById(aUniqueID);
        if (entity != null) {
            return entity.getItemValueBoolean("isMember");
        }
        return false;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        String type = workflowEvent.getWorkitem().getItemValueString("type");
        if (type.startsWith("workitem") && 20 == workflowEvent.getEventType()) {
            String processRef = workflowEvent.getWorkitem().getItemValueString("$uniqueidref");
            ItemCollection process = this.getProcessById(processRef);
            if (process != null) {
                workflowEvent.getWorkitem().replaceItemValue("process.Name", (Object)process.getItemValueString("name"));
                workflowEvent.getWorkitem().replaceItemValue("process.Ref", (Object)process.getItemValueString("$uniqueid"));
                workflowEvent.getWorkitem().replaceItemValue("txtProcessName", (Object)process.getItemValueString("name"));
                workflowEvent.getWorkitem().replaceItemValue("txtProcessRef", (Object)process.getItemValueString("$uniqueid"));
            } else {
                logger.fine("...unable to find process entity '" + processRef + "'!");
            }
        }
        if (type.startsWith("space") || type.startsWith("process")) {
            if (20 == workflowEvent.getEventType() || 21 == workflowEvent.getEventType()) {
                if (type.startsWith("space")) {
                    if (!workflowEvent.getWorkitem().hasItem("space.manager.label")) {
                        workflowEvent.getWorkitem().setItemValue("space.manager.label", (Object)this.resourceBundleHandler.findMessage("space.manager"));
                    }
                    if (!workflowEvent.getWorkitem().hasItem("space.team.label")) {
                        workflowEvent.getWorkitem().setItemValue("space.team.label", (Object)this.resourceBundleHandler.findMessage("space.team"));
                    }
                    if (!workflowEvent.getWorkitem().hasItem("space.assist.label")) {
                        workflowEvent.getWorkitem().setItemValue("space.assist.label", (Object)this.resourceBundleHandler.findMessage("space.assist"));
                    }
                }
                if (type.startsWith("process")) {
                    if (!workflowEvent.getWorkitem().hasItem("process.manager.label")) {
                        workflowEvent.getWorkitem().setItemValue("process.manager.label", (Object)this.resourceBundleHandler.findMessage("process.manager"));
                    }
                    if (!workflowEvent.getWorkitem().hasItem("process.team.label")) {
                        workflowEvent.getWorkitem().setItemValue("process.team.label", (Object)this.resourceBundleHandler.findMessage("process.team"));
                    }
                    if (!workflowEvent.getWorkitem().hasItem("process.assist.label")) {
                        workflowEvent.getWorkitem().setItemValue("process.assist.label", (Object)this.resourceBundleHandler.findMessage("process.assist"));
                    }
                }
            }
            if (23 == workflowEvent.getEventType()) {
                this.reset();
                logger.fine("ModelController:WorkflowEvent=" + workflowEvent.getEventType());
            }
        }
    }

    private List<ItemCollection> getMemberListByRole(String aUniqueID, String role) {
        ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
        ArrayList<String> dupplicatedIds = new ArrayList<String>();
        ItemCollection orgUnit = this.getEntityById(aUniqueID);
        if (orgUnit == null) {
            return resultList;
        }
        String type = orgUnit.getType();
        List members = orgUnit.getItemValue(type + "." + role);
        for (String member : members) {
            if (dupplicatedIds.contains(member)) continue;
            ItemCollection profile = this.profileService.findProfileById(member);
            if (profile != null) {
                resultList.add(profile);
            }
            dupplicatedIds.add(member);
        }
        return resultList;
    }
}

