/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.marty.team.TeamCache;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.UserGroupEvent;

@Stateless
@LocalBean
public class TeamLookupService {
    @Resource
    SessionContext ctx;
    @EJB
    TeamCache teamCache;
    @EJB
    private DocumentService documentService;
    private static Logger logger = Logger.getLogger(TeamLookupService.class.getName());

    public String[] findOrgunits(String userId) {
        String[] groups = (String[])this.teamCache.get(userId);
        if (groups != null) {
            return groups;
        }
        List<String> memberList = this.getMemberList("process", userId);
        memberList.addAll(this.getMemberList("space", userId));
        groups = new String[memberList.size()];
        groups = memberList.toArray(groups);
        this.teamCache.put(userId, groups);
        if (logger.isLoggable(Level.FINE)) {
            Object groupListe = "";
            for (String aGroup : groups) {
                groupListe = (String)groupListe + "'" + aGroup + "' ";
            }
            logger.finest("......resolved membership for '" + userId + " = " + (String)groupListe);
        }
        return groups;
    }

    public void onUserGroupEvent(@Observes UserGroupEvent userGroupEvent) {
        StackTraceElement[] stackTraceElements;
        long l = System.currentTimeMillis();
        for (StackTraceElement caller : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String classname = caller.getClassName();
            String methodName = caller.getMethodName();
            if (!classname.equals(TeamLookupService.class.getName()) || !"findOrgunits".equals(methodName)) continue;
            logger.finest("......found recursion from findOrgunits...");
            return;
        }
        String[] groups = this.findOrgunits(userGroupEvent.getUserId());
        userGroupEvent.setGroups(Arrays.asList(groups));
        logger.finest("......finished in " + (System.currentTimeMillis() - l) + "ms");
    }

    public void onDocumentEvent(@Observes DocumentEvent documentEvent) {
        String type;
        if ((documentEvent.getEventType() == 1 || documentEvent.getEventType() == 3) && ((type = documentEvent.getDocument().getType()).startsWith("space") || type.startsWith("process"))) {
            logger.finest("......reset teamCache");
            this.teamCache.resetCache();
        }
    }

    List<String> getMemberList(String type, String userId) {
        boolean isGeneralManager = false;
        boolean isGeneralTeam = false;
        boolean isGeneralAssist = false;
        boolean isGeneralMember = false;
        ArrayList<String> memberList = new ArrayList<String>();
        List col = this.documentService.getDocumentsByType(type);
        logger.fine(col.size() + " orgunits '" + type + "' found...");
        for (ItemCollection orgunit : col) {
            boolean isMember = false;
            List members = null;
            String orgunitName = orgunit.getItemValueString(type + ".name");
            members = orgunit.getItemValue(type + ".manager");
            if (members.stream().anyMatch(userId::equalsIgnoreCase)) {
                memberList.add("{" + type + ":" + orgunitName + ":manager}");
                memberList.add("{" + type + ":" + orgunit.getUniqueID() + ":manager}");
                isMember = true;
                isGeneralManager = true;
            }
            members = orgunit.getItemValue(type + ".team");
            if (members.stream().anyMatch(userId::equalsIgnoreCase)) {
                memberList.add("{" + type + ":" + orgunitName + ":team}");
                memberList.add("{" + type + ":" + orgunit.getUniqueID() + ":team}");
                isMember = true;
                isGeneralTeam = true;
            }
            members = orgunit.getItemValue(type + ".assist");
            if (members.stream().anyMatch(userId::equalsIgnoreCase)) {
                memberList.add("{" + type + ":" + orgunitName + ":assist}");
                memberList.add("{" + type + ":" + orgunit.getUniqueID() + ":assist}");
                isMember = true;
                isGeneralAssist = true;
            }
            if (!isMember) continue;
            memberList.add("{" + type + ":" + orgunitName + ":member}");
            memberList.add("{" + type + ":" + orgunit.getUniqueID() + ":member}");
            logger.finest(userId + " is member of '" + orgunitName + "'");
            isGeneralMember = true;
        }
        if (isGeneralManager) {
            memberList.add("{" + type + ":manager}");
        }
        if (isGeneralTeam) {
            memberList.add("{" + type + ":team}");
        }
        if (isGeneralAssist) {
            memberList.add("{" + type + ":assist}");
        }
        if (isGeneralMember) {
            memberList.add("{" + type + ":member}");
        }
        return memberList;
    }
}

